package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMessageReceive;

public class MetaMessageReceiveJSONHandler extends MetaNodeJSONHandler<MetaMessageReceive> {

	@Override
	public void fromJSONImpl(MetaMessageReceive meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setCondition(json.optString(JSONConstants.COMMON_CONDITION));
		meta.setMessageCount(json.optInt(JSONConstants.MESSAGE_COUNT));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaMessageReceive meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CONDITION, meta.getCondition());
		JSONHelper.writeToJSON(json, JSONConstants.MESSAGE_COUNT, meta.getMessageCount());
	}
	
	@Override
	public MetaMessageReceive newInstance() {
		return new MetaMessageReceive();
	}
}
