package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaExceptionFlow;

public class MetaExceptionFlowJSONHandler extends MetaTransitionJSONHandler<MetaExceptionFlow> {

	@Override
	public void fromJSONImpl(MetaExceptionFlow meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setExceptionType(json.optInt(JSONConstants.TRANSITION_EXCEPTION_TYPE));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaExceptionFlow meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.TRANSITION_EXCEPTION_TYPE, meta.getExceptionType());
	}
	
	@Override
	public MetaExceptionFlow newInstance() {
		return new MetaExceptionFlow();
	}
}
