package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.node.MetaEvent;

public class MetaEventJSONHandler extends MetaNodeJSONHandler<MetaEvent> {

	@Override
	public void fromJSONImpl(MetaEvent meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setEventTrigger(json.optString(JSONConstants.NODE_EVENTTRIGGER));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaEvent meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.NODE_EVENTTRIGGER, meta.getEventTrigger());
	}
	
	@Override
	public MetaEvent newInstance() {
		return new MetaEvent();
	}
}
