package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.node.MetaEnd;

public class MetaEndJSONHandler extends MetaNodeJSONHandler<MetaEnd> {

	@Override
	public void fromJSONImpl(MetaEnd meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setStatus(json.optString(JSONConstants.NODE_STATUS));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaEnd meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.NODE_STATUS, meta.getStatus());
	}
	
	@Override
	public MetaEnd newInstance() {
		return new MetaEnd();
	}
}
