package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataItem;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataItemCollection;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDataOutput;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaDataOutputJSONHandler extends MetaNodeJSONHandler<MetaDataOutput> {

	@Override
	public void fromJSONImpl(MetaDataOutput meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		String s = json.optString(JSONConstants.NODE_ACTION);
		if(s.length() > 0){
			MetaBaseScript action = new MetaBaseScript(BPMConstants.NODE_ACTION);
			action.setContent(s);
			meta.setAction(action);
		}
		JSONArray array = json.optJSONArray(JSONConstants.BPM_DATAITEMCOLLECTION);
		if(array != null){
			MetaDataItemCollection dataItemCollection = new MetaDataItemCollection();
			dataItemCollection.addAll(BPMJSONHandlerUtil.unbuild(MetaDataItem.class, array));
			meta.setDataItemCollection(dataItemCollection);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaDataOutput meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		MetaBaseScript action = meta.getAction();
		if(action != null){
			JSONHelper.writeToJSON(json, JSONConstants.NODE_ACTION, action.getContent().trim());
		}
		MetaDataItemCollection dataItemCollection = meta.getDataItemCollection();
		if(dataItemCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, dataItemCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_DATAITEMCOLLECTION, array);
		}
	}
	
	@Override
	public MetaDataOutput newInstance() {
		return new MetaDataOutput();
	}
}
