package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataItem;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataItemCollection;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDataInput;

public class MetaDataInputJSONHandler extends MetaNodeJSONHandler<MetaDataInput> {

	@Override
	public void fromJSONImpl(MetaDataInput meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		JSONArray array = json.optJSONArray(JSONConstants.BPM_DATAITEMCOLLECTION);
		if(array != null){
			MetaDataItemCollection dataItemCollection = new MetaDataItemCollection();
			dataItemCollection.addAll(BPMJSONHandlerUtil.unbuild(MetaDataItem.class, array));
			meta.setDataItemCollection(dataItemCollection);
		}
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaDataInput meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		MetaDataItemCollection dataItemCollection = meta.getDataItemCollection();
		if(dataItemCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, dataItemCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_DATAITEMCOLLECTION, array);
		}
		
	}
	
	@Override
	public MetaDataInput newInstance() {
		return new MetaDataInput();
	}
}
