package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMInfo;;

public class MetaBPMInfoJSONHandler extends AbstractJSONHandler<MetaBPMInfo, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaBPMInfo meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaBPMInfo meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		
	}
	
	@Override
	public MetaBPMInfo newInstance() {
		return new MetaBPMInfo();
	}
}
