package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.node.MetaAnchor;

public class MetaAnchorJSONHandler extends MetaNodeJSONHandler<MetaAnchor> {

	@Override
	public void fromJSONImpl(MetaAnchor meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setStraightNodeID(json.optInt(JSONConstants.NODE_STRAIGHT_NODE_ID));
		meta.setStraightEmbedNodeID(json.optInt(JSONConstants.NODE_STRAIGHT_EMBED_NODE_ID));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaAnchor meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.NODE_STRAIGHT_NODE_ID, meta.getStraightNodeID());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_STRAIGHT_EMBED_NODE_ID, meta.getStraightEmbedNodeID());
	}
	
	@Override
	public MetaAnchor newInstance() {
		return new MetaAnchor();
	}
}
