package com.bokesoft.yes.meta.json;

import java.util.Iterator;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.com.properties.BasePropertiesJSONHandler;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.CondSign;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.common.MetaCondition;
import com.bokesoft.yigo.meta.common.MetaPara;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaCustomParaCollection;
import com.bokesoft.yigo.meta.form.component.MetaFormat;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.i18n.MetaI18n;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.tools.ve.VE;

public abstract class BaseComponentJSONHandler<T extends MetaComponent> extends AbstractJSONHandler<T,DefaultSerializeContext> {

    protected BasePropertiesJSONHandler<? extends AbstractMetaObject> propertiesJSONHandler = null;

    @Override
    public void fromJSONImpl(T meta, JSONObject json) throws Throwable {
        meta.setKey(json.optString(JSONConstants.COMMON_KEY));
        meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
        meta.setCaptionFull(json.optString(JSONConstants.COMMON_CAPTION_FULL));
        meta.setCaptionEn(json.optString(JSONConstants.COMMON_CAPTION_EN));
        meta.setCaptionEnFull(json.optString(JSONConstants.COMMON_CAPTION_EN_FULL));
		meta.setFormulaCaption(json.optString(JSONConstants.COMMON_FORMULACAPTION));
		meta.setCaptionDependency(json.optString(JSONConstants.COMMON_CAPTIONDEPENDENCY));
        meta.setBuddyKey(json.optString(JSONConstants.COMPONENT_BUDDYKEY));
        meta.setBuddy(json.optBoolean(JSONConstants.COMPONENT_ISBUDDY));
        meta.setParentGridKey(json.optString(JSONConstants.COMPONENT_PARENTGRIDKEY));
        meta.setBindingCellKey(json.optString(JSONConstants.COMPONENT_BINDINGCELLKEY));
        meta.setEnable(json.optString(JSONConstants.COMMON_ENABLE));
        meta.setVisible(json.optString(JSONConstants.COMMON_VISIBLE));
        meta.setEnableDependency(json.optString(JSONConstants.COMMON_ENABLEDEPENDENCY));
        meta.setVisibleDependency(json.optString(JSONConstants.COMMON_VISIBLEDEPENDENCY));

        meta.setX(json.optInt(JSONConstants.COMPONENT_X));
        meta.setY(json.optInt(JSONConstants.COMPONENT_Y));
        meta.setXSpan(json.optInt(JSONConstants.COMPONENT_XSPAN));
        meta.setYSpan(json.optInt(JSONConstants.COMPONENT_YSPAN));
        meta.setParameterID(json.optString("parameterID"));
        meta.setSetParameter(json.optBoolean("setParameter"));
        meta.setGetParameter(json.optBoolean("getParameter"));

        String s = json.optString(JSONConstants.COMMON_WIDTH);
        if( s != null && !s.isEmpty() ) {
            meta.setWidth(DefSize.parse(s));
        }

        s = json.optString(JSONConstants.COMMON_HEIGHT);
        if( s != null && !s.isEmpty() ) {
            meta.setHeight(DefSize.parse(s));
        }

        s = json.optString(JSONConstants.COMMON_MINHEIGHT);
        if( s != null && !s.isEmpty() ) {
            meta.setMinHeight(DefSize.parse(s));
        }

        meta.setArea(json.optInt(JSONConstants.COMPONENT_AREA));
        meta.setPosition(json.optInt(JSONConstants.COMPONENT_POSITION));
        meta.setLeft(json.optInt(JSONConstants.COMPONENT_LEFT));
        meta.setRight(json.optInt(JSONConstants.COMPONENT_RIGHT));
        meta.setTop(json.optInt(JSONConstants.COMPONENT_TOP));
        meta.setBottom(json.optInt(JSONConstants.COMPONENT_BOTTOM));
        meta.setFloatType(json.optInt(JSONConstants.COMPONENT_FLOAT));
        meta.setPadding(json.optString(JSONConstants.COMMON_PANDDING));
        meta.setLeftPadding(json.optString(JSONConstants.COMMON_LEFTPANDDING));
        meta.setRightPadding(json.optString(JSONConstants.COMMON_RIGHTPADDING));
        meta.setTopPadding(json.optString(JSONConstants.COMMON_TOPPADDING));
        meta.setBottomPadding(json.optString(JSONConstants.COMMON_BOTTOMPADDING));

        meta.setMargin(json.optString(JSONConstants.COMMON_MARGIN));
        meta.setLeftMargin(json.optString(JSONConstants.COMMON_LEFTMARGIN));
        meta.setRightMargin(json.optString(JSONConstants.COMMON_RIGHTMARGIN));
        meta.setTopMargin(json.optString(JSONConstants.COMMON_TOPMARGIN));
        meta.setBottomMargin(json.optString(JSONConstants.COMMON_BOTTOMMARGIN));

        meta.setHAlign(json.optInt(JSONConstants.COMMON_HALIGN));
        meta.setVAlign(json.optInt(JSONConstants.COMMON_VALIGN));
        meta.setCssClass(json.optString(JSONConstants.COMMON_CSSCLASS));
        meta.setToolTip(json.optString(JSONConstants.BASECONTROL_TIP));
        meta.setFormulaTip(json.optString(JSONConstants.BASECONTROL_FORMULATIP));

        JSONObject o = json.optJSONObject(JSONConstants.COMPONENT_DATABINDING);
        if( o != null ) {
            MetaDataBinding dataBinding = UIJSONHandlerUtil.unbuild(MetaDataBinding.class, o);
            meta.setDataBinding(dataBinding);
        }

        meta.setBorderColor(json.optString(JSONConstants.COMPONENT_BORDERCOLOR));
        meta.setBorderRadius(json.optString(JSONConstants.COMPONENT_BORDERRADIUS));
        meta.setBorderWidth(json.optString(JSONConstants.COMPONENT_BORDERWIDTH));
        meta.setBorderStyle(json.optString(JSONConstants.COMPONENT_BORDERSTYLE));
        meta.setTabOrder(json.optInt(JSONConstants.COMPONENT_TABORDER));

        o = json.optJSONObject(JSONConstants.COMPONENT_CONDITION);
        if( o != null ) {
            MetaCondition condition = UIJSONHandlerUtil.unbuild(MetaCondition.class, o);
            meta.setCondition(condition);
        }

        s = json.optString(JSONConstants.Event_Activate);
        if( s != null && !s.isEmpty() ) {
            MetaBaseScript active = new MetaBaseScript(MetaConstants.Event_Activate);
            active.setContent(s);
            meta.setActivate(active);
        }

        meta.setWeight(Float.parseFloat(json.optString(JSONConstants.COMMON_WEIGHT)));
        meta.setAsQuery(json.optBoolean(JSONConstants.COMPONENT_ASQUERY));
        meta.setClearable(json.optBoolean(JSONConstants.COMMON_CLEARABLE));
        meta.setCopyNew(json.optBoolean(JSONConstants.COMPONENT_COPYNEW));

        o = json.optJSONObject(JSONConstants.COMPONENT_I18N);
        if( o != null ) {
            MetaI18n i18n = UIJSONHandlerUtil.unbuild(MetaI18n.class, o);
            meta.setI18n(i18n);
        }

        o = json.optJSONObject(JSONConstants.COMMON_FORMAT);
        if( o != null ) {
            MetaFormat format = UIJSONHandlerUtil.unbuild(MetaFormat.class, o);
            meta.setFormat(format);
        }

        s = json.optString(JSONConstants.COMMON_INITENABLE);
        if( s != null && !s.isEmpty() ) {
            meta.setInitEnable(Boolean.valueOf(s));
        }

        s = json.optString(JSONConstants.COMMON_INITVISIBLE);
        if( s != null && !s.isEmpty() ) {
            meta.setInitVisible(Boolean.valueOf(s));
        }

        Object onlyShowObj = json.opt(JSONConstants.COMPONENT_ONLYSHOW);
        if(onlyShowObj != null){
            meta.setOnlyShow(Boolean.parseBoolean(onlyShowObj.toString()));
        }

        meta.setExtend(json.optBoolean(JSONConstants.COMPONENT_EXTEND));

        o = json.optJSONObject(JSONConstants.COMPONENT_PROPERTIES);
        if( o != null && propertiesJSONHandler != null ) {
            AbstractMetaObject properties = propertiesJSONHandler.fromJSON(o);
            meta.setProperties(properties);
        }
        meta.setCompStyle(json.optString(JSONConstants.COMPONENT_COMPSTYLE));
        meta.setOneTimeCompute(json.optBoolean(JSONConstants.COMPONENT_ONETIMECOMPUTE));


        JSONArray array = json.optJSONArray(JSONConstants.COMPONENT_CUSTOMPARACOLLECTION);
		if (array != null) {
			MetaCustomParaCollection customParaCollection = new MetaCustomParaCollection();
			List<MetaPara> list = UIJSONHandlerUtil.unbuild(MetaPara.class, array);
			customParaCollection.addAll(list);
			meta.setCumstomParas(customParaCollection);
		}
    }

    @Override
    public void toJSONImpl(JSONObject json, T meta, DefaultSerializeContext hook) throws Throwable {

        JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getControlType());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_TAGNAME, meta.getTagName());

        String caption = hook.getCaptionString(GroupKeyTable.STR_UI, "", meta.getKey(), meta.getCaption(), meta);
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, caption);
        String captionFull = hook.getCaptionString(GroupKeyTable.STR_UI, "", meta.getKey(), meta.getCaption(), meta, true);
        if (captionFull != null && !captionFull.isEmpty()) {
            JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION_FULL, captionFull);
        }
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORMULACAPTION, meta.getFormulaCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTIONDEPENDENCY, meta.getCaptionDependency());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_BINDINGCELLKEY, meta.getBindingCellKey());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_ENABLE, meta.getEnable());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_VISIBLE, meta.getVisible());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_VISIBLEDEPENDENCY, meta.getVisibleDependency());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_ENABLEDEPENDENCY, meta.getEnableDependency());

        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_X, meta.getX());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_Y, meta.getY());

        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_XSPAN, meta.getXSpan());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_YSPAN, meta.getYSpan());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PARENTGRIDKEY, meta.getParentGridKey());

        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_ISBUDDY, meta.isBuddy());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_BUDDYKEY, meta.getBuddyKey());
        JSONHelper.writeToJSON(json, "parameterID", meta.getParameterID());
        JSONHelper.writeToJSON(json, "setParameter", meta.isSetParameter());
        JSONHelper.writeToJSON(json, "getParameter", meta.isGetParameter());

        DefSize width = meta.getWidth();
        if( width != null ) {
            JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, width.toString(), "");
        }

        DefSize height = meta.getHeight();
        if( height != null ) {
            JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, height.toString(), "");
        }

        DefSize minHeight = meta.getMinHeight();
        if( minHeight != null ) {
            JSONHelper.writeToJSON(json, JSONConstants.COMMON_MINHEIGHT, minHeight.toString(), "");
        }
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_EXTENDJSON, new JSONObject(meta.getExtendJson()));
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_AREA, meta.getArea());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_POSITION, meta.getPosition());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_LEFT, meta.getLeft());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_RIGHT, meta.getRight());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_TOP, meta.getTop());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_BOTTOM, meta.getBottom());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_FLOAT, meta.getFloatType());

        JSONHelper.writeToJSON(json, JSONConstants.COMMON_PANDDING, meta.getPadding());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_LEFTPANDDING, meta.getLeftPadding());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_RIGHTPADDING, meta.getRightPadding());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_TOPPADDING, meta.getTopPadding());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_BOTTOMPADDING, meta.getBottomPadding());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_MARGIN, meta.getMargin());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_LEFTMARGIN, meta.getLeftMargin());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_RIGHTMARGIN, meta.getRightMargin());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_TOPMARGIN, meta.getTopMargin());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_BOTTOMMARGIN, meta.getBottomMargin());

        JSONHelper.writeToJSON(json, JSONConstants.COMMON_HALIGN, meta.getHAlign());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_VALIGN, meta.getVAlign());

        JSONHelper.writeToJSON(json, JSONConstants.COMMON_CSSCLASS, meta.getCssClass());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_TABLEKEY, meta.getTableKey());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_COLUMNKEY, meta.getColumnKey());
        String valueChanged = meta.getValueChanged();
        if(valueChanged != null) {
        	JSONHelper.writeToJSON(json, JSONConstants.COMMON_VALUECHANGED, valueChanged.trim(), "");
        }
        String valueChanging = meta.getValueChanging();
        if(valueChanging != null) {
        	JSONHelper.writeToJSON(json, JSONConstants.COMMON_VALUECHANGING, valueChanging.trim(), "");
        }
        String valueChangeAction = meta.getValueChangeAction();
        if(valueChangeAction != null) {
        	JSONHelper.writeToJSON(json, JSONConstants.COMMON_VALUECHANGEACTION, valueChangeAction.trim(), "");
        }

        if (meta.getToolTip() != null && !meta.getToolTip().isEmpty()) {
            String tooltip = hook.getString(GroupKeyTable.STR_TIP, "", meta.getKey(), meta.getToolTip());
            JSONHelper.writeToJSON(json, JSONConstants.BASECONTROL_TIP, tooltip);
        }

        if (meta.getFormulaTip() != null && !meta.getFormulaTip().isEmpty()) {
            JSONHelper.writeToJSON(json, JSONConstants.BASECONTROL_FORMULATIP, meta.getFormulaTip());
        }

        MetaDataBinding dataBinding = meta.getDataBinding();
        if( dataBinding != null ) {
            JSONObject o = UIJSONHandlerUtil.build(dataBinding,hook);
            String errorInfo = hook.getCaptionString(GroupKeyTable.STR_ERROR, "", meta.getKey(), dataBinding.getErrorInfo(), meta);
            JSONHelper.writeToJSON(o, JSONConstants.CHECKRULE_ERRORINFO, errorInfo);
            JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_DATABINDING, o);
        }

        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_BORDERCOLOR, meta.getBorderColor());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_BORDERRADIUS, meta.getBorderRadius());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_BORDERWIDTH, meta.getBorderWidth());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_BORDERSTYLE, meta.getBorderStyle());

        MetaCondition condition = meta.getCondition();
        if( condition != null ) {
            JSONObject object = UIJSONHandlerUtil.build(condition,hook);
            if (meta.getControlType() == ControlType.LABEL
                    || meta.getControlType() == ControlType.BUTTON
                    || meta.getControlType() == ControlType.CHECKBOX
                    || meta.getControlType() == ControlType.RICHEDITOR
                    || meta.getControlType() == ControlType.PASSWORDEDITOR
                    || meta.getControlType() == ControlType.CHECKLISTBOX
                    || meta.getControlType() == ControlType.TEXTBUTTON
                    || meta.getControlType() == ControlType.RADIOBUTTON || condition.getSign() == CondSign.NONE || condition.getSign() == CondSign.CUSTOM) {
                JSONHelper.writeToJSON(object, JSONConstants.COMPONENT_USE_ADVANCED_QUERY, false, true);
            } else {
                object.put(JSONConstants.COMPONENT_USE_ADVANCED_QUERY, condition.isUseAdvancedQuery());
            }
            JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_CONDITION, object);
        }

        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_RECEIVEFOCUS, meta.receiveFocus());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_TABORDER, meta.getTabOrder());

        MetaBaseScript activate = meta.getActivate();
        if( activate != null ) {
            JSONHelper.writeToJSON(json, JSONConstants.Event_Activate, activate.getContent().trim());
        }

        JSONHelper.writeToJSON(json, JSONConstants.COMMON_WEIGHT,meta.getWeight());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_ASQUERY, meta.isAsQuery());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_CLEARABLE, meta.isClearable());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_COPYNEW, meta.isCopyNew());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_ISSUBDETAIL, meta.isSubDetail());

        MetaI18n i18n = meta.getI18n();
        if( i18n != null ) {
            JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, i18n);
            JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_I18N, array);
        }

        Boolean initEnable = meta.getInitEnable();
        if( initEnable != null ) {
            JSONHelper.writeToJSON(json, JSONConstants.COMMON_INITENABLE, initEnable.toString());
        }
        Boolean initVisible = meta.getInitVisible();
        if( initVisible != null ) {
            JSONHelper.writeToJSON(json, JSONConstants.COMMON_INITVISIBLE, initVisible.toString());
        }

        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_ONLYSHOW, meta.isOnlyShow());

        MetaFormat format = meta.getFormat();
        if( format != null ) {
            JSONObject o = UIJSONHandlerUtil.build(format,hook);
            JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORMAT, o);
        }

        // 以下属性并非来自配置文件，无需读写
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_EXTEND, meta.isExtend());

        AbstractMetaObject properties = meta.getProperties();
        if( properties != null && propertiesJSONHandler != null ) {
            JSONObject o = propertiesJSONHandler.toJSON(properties, hook, meta.getKey());
            JSONHelper.writeToJSON(o, JSONConstants.COMMON_KEY, meta.getKey());
            JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROPERTIES, o);
        }

        // 访问控制
        if( meta.hasDataBinding() ) {
            JSONHelper.writeToJSON(json, JSONConstants.ACCESS_CONTROL, meta.isAccessControl());
        }

        // 数据源默认值
        JSONHelper.writeToJSON(json, JSONConstants.DS_DEFAULTVALUE, meta.getDsDefaultValue());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_ISNEWEXTFIELD, meta.isNewExtField()); // 是否是马甲新增的字段
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_COMPSTYLE, meta.getCompStyle());
        JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_ONETIMECOMPUTE, meta.getOneTimeCompute());


        MetaCustomParaCollection customParaCollection = meta.getCumstomParas();
        if( customParaCollection != null ) {
        	JSONArray array = new JSONArray();
    		Iterator<MetaPara> itPara = customParaCollection.iterator();
    		while ( itPara.hasNext() ) {
    			MetaPara metaItem = itPara.next();
    			JSONObject itemJSON = UIJSONHandlerUtil.build(metaItem,hook);
    			array.put(itemJSON);
    		}
            JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_CUSTOMPARACOLLECTION, array);
        }

        final MetaForm metaForm = hook.getMetaForm();
        if (metaForm != null && meta.hasDataBinding() && !metaForm.getFormType().equals(FormType.Template)) {
            final VE ve = hook.getVE();
            IMetaFactory metaFactory = ve.getMetaFactory();
            final MetaDataObject dataObject = MetaUtil.getDataObject(metaFactory, metaForm);
            if (dataObject != null) {
                final String tableKey = meta.getTableKey();
                final String columnKey = meta.getColumnKey();
                final MetaTable table = dataObject.getTable(tableKey);
                final MetaColumn metaColumn = table.get(columnKey);
                final String dataElementKey = metaColumn.getDataElementKey();
                MetaDataElement dataElement = metaColumn.getDataElement();
                if (dataElement == null && dataElementKey != null && !dataElementKey.isEmpty()) {
                    dataElement = MetaUtil.getDataElement(metaFactory, dataElementKey);
                }
                if (dataElement != null) {
                    final Boolean noHistory = dataElement.getNoHistory();
                    JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_NO_HISTORY, noHistory);
                    JSONHelper.writeToJSON(json, "parameterID", dataElement.getParamID());
                }
            }
        }
    }
}