package com.bokesoft.yes.meta.json;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public abstract class AbstractJSONHandler<T extends AbstractMetaObject,C extends ISerializeContext> implements IJSONHandler<T,C> {
	
	@Override
	public final JSONObject toJSON(T meta, C hook) throws Throwable {
		JSONObject json = create();
		this.toJSONImpl(json, meta, hook);
		return json;
	}
		
	public abstract void toJSONImpl(JSONObject json, T meta, C hook) throws Throwable;
	
	public JSONObject create() throws Throwable {
		return new JSONObject();
	}
	
	@Override
	public final T fromJSON(JSONObject json) throws Throwable {
		T meta = newInstance();
		this.fromJSONImpl(meta, json);
		return meta;
	}
	
	public abstract T newInstance();
	
	public abstract void fromJSONImpl(T meta, JSONObject json) throws Throwable;
	
}
