package com.bokesoft.yes.meta.json.soluton;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.commondef.MetaStatus;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.paratable.MetaParaGroup;
import com.bokesoft.yigo.meta.paratable.MetaParaTable;

public class MetaCommonDefJSONHandler extends AbstractJSONHandler<MetaCommonDef,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaCommonDef meta, SolutionSerializeContext hook) throws Throwable {
		MetaStatusCollection statusCollection = meta.getStatusCollection();
		if( statusCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, statusCollection);
			JSONHelper.writeToJSON(json, JSONConstants.COMMONDEF_STATUSCOLLECTION, array);
		}
		
		MetaMacroCollection macroCollection = meta.getMacroCollection();
		if( macroCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, macroCollection);
			JSONHelper.writeToJSON(json, JSONConstants.COMMONDEF_MACROCOLLECTION, array);
		}
	}

	@Override
	public MetaCommonDef newInstance() {
		return new MetaCommonDef();
	}

	@Override
	public void fromJSONImpl(MetaCommonDef meta, JSONObject json) throws Throwable {
		JSONArray array = json.optJSONArray(JSONConstants.COMMONDEF_STATUSCOLLECTION);
		if( array != null ) {
			List<MetaStatus> list = UIJSONHandlerUtil.unbuild(MetaStatus.class, array);
			MetaStatusCollection collection = new MetaStatusCollection();
			collection.addAll(list);
			meta.setStatusCollection(collection);
		}
		
		array = json.optJSONArray(JSONConstants.COMMONDEF_MACROCOLLECTION);
		if( array != null ) {
			List<MetaMacro> list = UIJSONHandlerUtil.unbuild(MetaMacro.class, array);
			MetaMacroCollection collection = new MetaMacroCollection();
			collection.addAll(list);
			meta.setMacroCollection(collection);
		}
		
	}

}
