package com.bokesoft.yes.meta.json.report;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.ReportJSONHandlerUtil;
import com.bokesoft.yigo.meta.report.MetaReportGridColumn;
import com.bokesoft.yigo.meta.report.MetaReportGridColumns;
import com.bokesoft.yigo.meta.report.MetaReportGridRow;
import com.bokesoft.yigo.meta.report.MetaReportGridRows;
import com.bokesoft.yigo.meta.report.MetaReportGridSection;

public class MetaReportGridSectionHandler extends AbstractJSONHandler<MetaReportGridSection,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportGridSection meta, SolutionSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getType());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_MINIFILLROWCOUNT, meta.getMinFillRowCount());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_PAGEBREAKPOLICY, meta.getPageBreakPolicy());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_SPLITROW, meta.isSplitRow());
		
		MetaReportGridColumns columns = meta.getColumns();
		if( columns != null ) {
			JSONArray array = ReportJSONHandlerUtil.buildNoKeyCollection(hook, columns);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_COLUMNS, array);
		}
		
		MetaReportGridRows rows = meta.getRows();
		if( rows != null ) {
			JSONArray array = ReportJSONHandlerUtil.buildNoKeyCollection(hook, rows);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_ROWS, array);
		}
	}

	@Override
	public MetaReportGridSection newInstance() {
		return new MetaReportGridSection();
	}

	@Override
	public void fromJSONImpl(MetaReportGridSection meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setType(json.optInt(JSONConstants.COMMON_TYPE));
		meta.setMinFillRowCount(json.optInt(JSONConstants.REPORT_MINIFILLROWCOUNT));
		meta.setPageBreakPolicy(json.optInt(JSONConstants.REPORT_PAGEBREAKPOLICY));
		meta.setSplitRow(json.optBoolean(JSONConstants.REPORT_SPLITROW));
		
		JSONArray array = json.optJSONArray(JSONConstants.REPORT_COLUMNS);
		List<MetaReportGridColumn> list = ReportJSONHandlerUtil.unbuild(MetaReportGridColumn.class, array);
		MetaReportGridColumns columns = new MetaReportGridColumns();
		columns.addAll(0, list);
		meta.setColumns(columns);
		
		array = json.optJSONArray(JSONConstants.REPORT_ROWS);
		List<MetaReportGridRow> list1 = ReportJSONHandlerUtil.unbuild(MetaReportGridRow.class, array);
		MetaReportGridRows rows = new MetaReportGridRows();
		rows.addAll(0, list1);
		meta.setRows(rows);
	}

}
