package com.bokesoft.yes.meta.json.report;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.ReportJSONHandlerUtil;
import com.bokesoft.yigo.meta.report.MetaReportDataSource;
import com.bokesoft.yigo.meta.report.MetaReportDataTable;

public class MetaReportDataSourceJSONHandler extends AbstractJSONHandler<MetaReportDataSource,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportDataSource meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		
		JSONArray array = ReportJSONHandlerUtil.buildKeyWithKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
	}

	@Override
	public MetaReportDataSource newInstance() {
		return new MetaReportDataSource();
	}

	@Override
	public void fromJSONImpl(MetaReportDataSource meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if( array != null ) {
			List<MetaReportDataTable> list = ReportJSONHandlerUtil.unbuild(MetaReportDataTable.class, array);
			meta.addAll(list);
		}
	}

}
