package com.bokesoft.yes.meta.json.panel;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.panel.MetaWizardPanel;

public class MetaWizardPanelJSONHandler extends BasePanelJSONHandler<MetaWizardPanel> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaWizardPanel meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		MetaBaseScript finish = meta.getFinish();
		if( finish != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.WIZARDPANEL_FINISH, finish.getContent().trim());
		}
	}
	
	@Override
	public void fromJSONImpl(MetaWizardPanel meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		String s = json.optString(JSONConstants.WIZARDPANEL_FINISH);
		if (s != null && !s.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_Finish);
			script.setContent(s);
			meta.setFinish(script);
		}
	}

	@Override
	public MetaWizardPanel newInstance() {
		return new MetaWizardPanel();
	}
}
