package com.bokesoft.yes.meta.json.other;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.common.MetaInplaceToolbar;

public class MetaInplaceToolbarJSONHandler extends AbstractJSONHandler<MetaInplaceToolbar,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaInplaceToolbar meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.INPLACETOOLBAR_TAG, meta.getTag());
		JSONHelper.writeToJSON(json, JSONConstants.INPLACETOOLBAR_HANDLER, meta.getHandler());
		JSONHelper.writeToJSON(json, JSONConstants.INPLACETOOLBAR_DESCRIPTION, meta.getDescription());
	}

	@Override
	public MetaInplaceToolbar newInstance() {
		return new MetaInplaceToolbar();
	}

	@Override
	public void fromJSONImpl(MetaInplaceToolbar meta, JSONObject json) throws Throwable {
		meta.setTag(json.optString(JSONConstants.INPLACETOOLBAR_TAG));
		meta.setHandler(json.optString(JSONConstants.INPLACETOOLBAR_HANDLER));
		meta.setDescription(json.optString(JSONConstants.INPLACETOOLBAR_DESCRIPTION));
	}

}
