package com.bokesoft.yes.meta.json.mobiledef;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.mobiledef.MetaExtClass;

public class MetaExtClassJSONHandler extends AbstractJSONHandler<MetaExtClass,SolutionSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaExtClass meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.EXTCLASS_PLATFORM, meta.getPlatform());
		JSONHelper.writeToJSON(json, JSONConstants.EXTCLASS_PATH, meta.getPath());
		JSONHelper.writeToJSON(json, JSONConstants.EXTCLASS_INITCLASS, meta.getInitClass());
	}

	@Override
	public MetaExtClass newInstance() {
		return new MetaExtClass();
	}

	@Override
	public void fromJSONImpl(MetaExtClass meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setPath(json.optString(JSONConstants.EXTCLASS_PATH));
		meta.setInitClass(json.optString(JSONConstants.EXTCLASS_INITCLASS));
		meta.setPlatform(json.optInt(JSONConstants.EXTCLASS_PLATFORM));
	}
}
