package com.bokesoft.yes.meta.json.layout;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutColumn;

public class MetaLayoutColumnJSONHandler extends AbstractJSONHandler<MetaLayoutColumn,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaLayoutColumn meta, DefaultSerializeContext hook)
			throws Throwable {
		DefSize width = meta.getWidth();
		if( width != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, width.toString(), "");
		}
	}

	@Override
	public void fromJSONImpl(MetaLayoutColumn meta, JSONObject json) throws Throwable {
		String s = json.optString(JSONConstants.COMMON_WIDTH);
		if (s != null && !s.isEmpty()) {
			meta.setWidth(DefSize.parse(s));
		}
	}

	@Override
	public MetaLayoutColumn newInstance() {
		return new MetaLayoutColumn();
	}

}
