package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.ISerializeContext;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;

public class MetaColumnJSONHandler extends AbstractJSONHandler<MetaColumn,ISerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaColumn meta, ISerializeContext hook)
			throws Throwable {
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
        JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getDataType());
		JSONHelper.writeToJSON(json, JSONConstants.ACCESS_CONTROL, meta.isAccessControl());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DEFAULTVALUE, meta.getDefaultValue());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ISPRIMARY, meta.getIsPrimary());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_SCALE, meta.getScale());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_LENGTH, meta.getLength());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_PRECISION, meta.getPrecision());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_SORT, meta.getSort());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DEFAULTFORMULAVALUE, meta.getDefaultFormulaValue());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DESCRIPTION, meta.getDescription());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_DBCOLUMNNAME, meta.getDBColumnName());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_CACHE, meta.getCache());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_NEEDRIGHTS, meta.getNeedRights());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_ITEMKEY, meta.getItemKey());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_EXPAND, meta.isExpand());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_HIDDEN, meta.isHidden());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_GROUPTYPE, meta.getGroupType());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_SPLITTYPE, meta.getSplitType());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_IGNORESAVE, meta.isIgnoreSave());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_IGNORE_QUERY, meta.isIgnoreQuery());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_IGNORE_MODIFY, meta.isIgnoreModify());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_LOCALTIMEZONE, meta.isLocalTimeZone());
		JSONHelper.writeToJSON(json, JSONConstants.Column_PERIOD_GRANULARITY, meta.getPeriodGranularity());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_PERIODIMPL, meta.getPeriodImpl());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_USERTAG, meta.getUserTag());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_SUPPORTI18N, meta.isSupportI18n());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_PERSIST, meta.isPersist());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_REFCOL, meta.getRefCol());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_REFITEMKEYCOL, meta.getRefItemKeyCol());
	}

	@Override
	public MetaColumn newInstance() {
		return new MetaColumn();
	}

	@Override
	public void fromJSONImpl(MetaColumn meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setDataType(json.optInt(JSONConstants.COMMON_TYPE));
		meta.setAccessControl(json.optBoolean(JSONConstants.ACCESS_CONTROL));
		meta.setDefaultValue(json.optString(JSONConstants.COMMON_DEFAULTVALUE));
		meta.setIsPrimary(json.optBoolean(JSONConstants.COMMON_ISPRIMARY));
		meta.setScale(json.optInt(JSONConstants.COMMON_SCALE));
		meta.setLength(json.optInt(JSONConstants.COMMON_LENGTH));
		meta.setPrecision(json.optInt(JSONConstants.COMMON_PRECISION));
		meta.setSort(json.optInt(JSONConstants.COMMON_SORT));
		meta.setDefaultFormulaValue(json.optString(JSONConstants.COMMON_DEFAULTFORMULAVALUE));
		meta.setDescription(json.optString(JSONConstants.COMMON_DESCRIPTION));
		meta.setDBColumnName(json.optString(JSONConstants.COLUMN_DBCOLUMNNAME));
		meta.setCache(json.optBoolean(JSONConstants.COLUMN_CACHE));
		meta.setNeedRights(json.optInt(JSONConstants.COLUMN_NEEDRIGHTS));
		meta.setItemKey(json.optString(JSONConstants.COLUMN_ITEMKEY));
		meta.setExpand(json.optBoolean(JSONConstants.COLUMN_EXPAND));
		meta.setHidden(json.optBoolean(JSONConstants.COLUMN_HIDDEN));
		meta.setGroupType(json.optInt(JSONConstants.COLUMN_GROUPTYPE));
		meta.setSplitType(json.optInt(JSONConstants.COLUMN_SPLITTYPE));
		meta.setIgnoreSave(json.optBoolean(JSONConstants.COLUMN_IGNORESAVE));
		meta.setIgnoreQuery(json.optBoolean(JSONConstants.COLUMN_IGNORE_QUERY));
		meta.ignoreModify(json.optBoolean(JSONConstants.COLUMN_IGNORE_MODIFY));
		meta.setLocalTimeZone(json.optBoolean(JSONConstants.COLUMN_LOCALTIMEZONE));
		meta.setPeriodGranularity(json.optInt(JSONConstants.Column_PERIOD_GRANULARITY));
		meta.setPeriodImpl(json.optString(JSONConstants.COLUMN_PERIODIMPL));
		meta.setUserTag(json.optString(JSONConstants.COLUMN_USERTAG));
		meta.setSupportI18n(json.optBoolean(JSONConstants.COLUMN_SUPPORTI18N));
		meta.setPersist(json.getBoolean(JSONConstants.COLUMN_PERSIST));
		meta.setRefCol(json.optString(JSONConstants.COLUMN_REFCOL));
		meta.setRefItemKeyCol(json.optString(JSONConstants.COLUMN_REFITEMKEYCOL));
	}

}