package com.bokesoft.yes.meta.json.dynamic;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.PropertiesJSONHandlerMap;
import com.bokesoft.yes.meta.json.com.properties.BasePropertiesJSONHandler;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaCondition;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeDef;

public class MetaCellTypeDefJSONHandler extends AbstractJSONHandler<MetaCellTypeDef,DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaCellTypeDef meta, DefaultSerializeContext hook)
			throws Throwable {		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_CELLTYPE, meta.getType());
		
		MetaCondition condition = meta.getCondition();
		if( condition != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_TABLEKEY, condition.getTableKey());
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_COLUMNKEY, condition.getColumnKey());
		}
		
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ALWAYSSHOW, MetaGridCell.isAlwaysShow(meta.getType()));
			
		BasePropertiesJSONHandler<AbstractMetaObject> propertesbuilder = PropertiesJSONHandlerMap.getBuilder(meta.getType());		
		if( propertesbuilder != null ) {
			JSONObject o = propertesbuilder.toJSON(meta.getProperties(), hook, meta.getKey());
			
			JSONHelper.writeToJSON(o, JSONConstants.COMMON_KEY, meta.getKey());
			JSONHelper.writeToJSON(o, JSONConstants.GRID_CELLTYPE, meta.getType());
			
			JSONHelper.writeToJSON(json, JSONConstants.GRID_EDITOPTIONS, o); // properties
		}
	}

	@Override
	public MetaCellTypeDef newInstance() {
		return new MetaCellTypeDef();
	}

	@Override
	public void fromJSONImpl(MetaCellTypeDef meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setType(json.optInt(JSONConstants.GRID_CELLTYPE));
		
		JSONObject o = json.optJSONObject(JSONConstants.COMMON_CONDITION);
		if( o != null ) {
			MetaCondition condition = UIJSONHandlerUtil.unbuild(MetaCondition.class, o);
			meta.setCondition(condition);
		}
		
		o = json.optJSONObject(JSONConstants.GRID_EDITOPTIONS);
		BasePropertiesJSONHandler<AbstractMetaObject> propertesbuilder = PropertiesJSONHandlerMap.getBuilder(meta.getType());
		if( o != null && propertesbuilder != null ) {
			AbstractMetaObject properties = propertesbuilder.fromJSON(o);
			meta.setProperties(properties);
		}
	}
	
}
