package com.bokesoft.yes.meta.json.com.properties;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaWizardListProperties;
import com.bokesoft.yigo.meta.form.component.control.wizardlist.MetaWizardItem;
import com.bokesoft.yigo.meta.form.component.control.wizardlist.MetaWizardItemCollection;
import com.bokesoft.yigo.meta.form.component.control.wizardlist.MetaWizardItemList;

public class MetaWizardListPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaWizardListProperties> {

	@Override
	public void toJSONImpl(JSONObject json, MetaWizardListProperties meta, DefaultSerializeContext hook, String key)
			throws Throwable {

		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, meta.getPromptText());
		JSONHelper.writeToJSON(json, JSONConstants.WIZARDLIST_EDITTYPE, meta.getEditType());

		MetaWizardItemCollection itemCollection = meta.getItemCollection();
		if( itemCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, itemCollection);
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
		}
		
		MetaWizardItemList itemList = meta.getItemList();
		if( itemList != null ) {
			JSONObject o = UIJSONHandlerUtil.build(itemList,hook);
			JSONHelper.writeToJSON(json, JSONConstants.WIZARDITEM_ITEMLIST, o);
		}
	}

	@Override
	public void fromJSONImpl(MetaWizardListProperties meta, JSONObject json) throws Throwable {
		meta.setPromptText(json.optString(JSONConstants.COMPONENT_PROMPTTEXT, ""));
		meta.setEditType(SelectEditType.parse(json.optString(JSONConstants.WIZARDLIST_EDITTYPE, "")));

		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if( array != null ) {
			MetaWizardItemCollection items = new MetaWizardItemCollection();
			List<MetaWizardItem> list = UIJSONHandlerUtil.unbuild(MetaWizardItem.class, array);
			items.addAll(list);
			meta.setItemCollection(items);
		}

		JSONObject o = json.optJSONObject(JSONConstants.WIZARDITEM_ITEMLIST);
		if( o != null ) {
			MetaWizardItemList list = UIJSONHandlerUtil.unbuild(MetaWizardItemList.class, o);
			meta.setItemList(list);
		}
	}

	@Override
	public MetaWizardListProperties newInstance() {
		return new MetaWizardListProperties();
	}

}
