package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTimePickerProperties;

public class MetaTimePickerPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaTimePickerProperties>{
	
	@Override
	public void toJSONImpl(JSONObject json, MetaTimePickerProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.TIMEPICKER_FORMATSTR, meta.getDateFormat());
		JSONHelper.writeToJSON(json, JSONConstants.TIMEPICKER_SECOND, meta.isSecond());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, meta.getPromptText());
		JSONHelper.writeToJSON(json, JSONConstants.TIMEPICKER_EDITTYPE, meta.getEditType());
	}

	@Override
	public void fromJSONImpl(MetaTimePickerProperties meta, JSONObject json) throws Throwable {
		meta.setDateFormat(json.optString(JSONConstants.TIMEPICKER_FORMATSTR));
		meta.setSecond(json.optBoolean(JSONConstants.TIMEPICKER_SECOND));
		meta.setPromptText(json.optString(JSONConstants.COMPONENT_PROMPTTEXT));
		meta.setEditType(json.optInt(JSONConstants.TIMEPICKER_EDITTYPE));
	}

	@Override
	public MetaTimePickerProperties newInstance() {
		return new MetaTimePickerProperties();
	}

}
