package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextButtonProperties;

public class MetaTextButtonPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaTextButtonProperties> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaTextButtonProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.TEXTBUTTON_MAXLENGTH, meta.getMaxLength(), 255);
		JSONHelper.writeToJSON(json, JSONConstants.TEXTBUTTON_INVALIDCHARS, meta.getInvalidChars());
		JSONHelper.writeToJSON(json, JSONConstants.TEXTBUTTON_TEXTCASE, meta.getCaseType());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, hook.getString(GroupKeyTable.STR_PROMPT, "", key, meta.getPromptText()));
		JSONHelper.writeToJSON(json, JSONConstants.TEXTBUTTON_USEFORMULAMODEL, meta.getUseFormulaModel(), false);
		JSONHelper.writeToJSON(json, JSONConstants.TEXTBUTTON_ICON, meta.getIcon(), "");
		JSONHelper.writeToJSON(json, JSONConstants.TEXTBUTTON_EMBEDTEXT, hook.getString(GroupKeyTable.STR_EMBED, "", key, meta.getEmbedText()), "");
		
		MetaBaseScript onClick = meta.getOnClick();
		if(onClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent().trim());
		}

		MetaBaseScript keyEnter = meta.getKeyEnter();
		if(keyEnter != null) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_KeyEnter, keyEnter.getContent().trim());
		}
	}

	@Override
	public void fromJSONImpl(MetaTextButtonProperties meta, JSONObject json) throws Throwable {
		meta.setMaxLength(json.optInt(JSONConstants.TEXTBUTTON_MAXLENGTH));
		meta.setInvalidChars(json.optString(JSONConstants.TEXTBUTTON_INVALIDCHARS));
		meta.setCaseType(json.optInt(JSONConstants.TEXTBUTTON_TEXTCASE));
		meta.setPromptText(json.optString(JSONConstants.COMPONENT_PROMPTTEXT));
		meta.setIcon(json.optString(JSONConstants.TEXTBUTTON_ICON));
		meta.setEmbedText(json.optString(JSONConstants.TEXTBUTTON_EMBEDTEXT));
		
		String s = json.optString(JSONConstants.Event_OnClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnClick);
			script.setContent(s);
			meta.setOnClick(script);
		}
		
		s = json.optString(JSONConstants.Event_KeyEnter);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_KeyEnter);
			script.setContent(s);
			meta.setKeyEnter(script);
		}
	}

	@Override
	public MetaTextButtonProperties newInstance() {
		return new MetaTextButtonProperties();
	}

}
