package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.progressindicator.MetaProgressItem;

public class MetaProgressItemJSONHandler extends AbstractJSONHandler<MetaProgressItem,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaProgressItem meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_ITEM_TITLE, meta.getTitle());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_ITEM_MESSAGE, meta.getMessage());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSINDICATOR_ITEM_DATETIME, meta.getDateTime());
	}

	@Override
	public void fromJSONImpl(MetaProgressItem meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setTitle(json.optString(JSONConstants.PROGRESSINDICATOR_ITEM_TITLE));
		meta.setMessage(json.optString(JSONConstants.PROGRESSINDICATOR_ITEM_MESSAGE));
		meta.setDateTime(json.optString(JSONConstants.PROGRESSINDICATOR_ITEM_DATETIME));
	}

	@Override
	public MetaProgressItem newInstance() {
		return new MetaProgressItem();
	}

}
