package com.bokesoft.yes.meta.json.com.properties;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.MetaImageListItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaImageListProperties;

public class MetaImageListPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaImageListProperties> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaImageListProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
//		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_STRETCH, meta.isStretch());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_IMAGESCALETYPE, meta.getImageScaleType());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_PROMPTIMAGE, meta.getPromptImage());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_RADIUS, meta.getRadius());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_MASKIMAGE, meta.getMaskImage());
		
		JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);

		MetaBaseScript onClick = meta.getOnClick();
		if(onClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent());
		}
	}

	@Override
	public void fromJSONImpl(MetaImageListProperties meta, JSONObject json) throws Throwable {
//		meta.setStretch(json.optBoolean(JSONConstants.IMAGE_STRETCH));
		meta.setImageScaleType(json.optInt(JSONConstants.IMAGE_IMAGESCALETYPE));
		meta.setPromptImage(json.optString(JSONConstants.IMAGE_PROMPTIMAGE));
		meta.setRadius(json.optInt(JSONConstants.IMAGE_RADIUS));
		meta.setMaskImage(json.optString(JSONConstants.IMAGE_MASKIMAGE));
		
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if( array != null ) {
			List<MetaImageListItem> list = UIJSONHandlerUtil.unbuild(MetaImageListItem.class, array);
			meta.addAll(list);
		}
		
		String s = json.optString(JSONConstants.Event_OnClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnClick);
			script.setContent(s);
			meta.setOnClick(script);
		}
	}

	@Override
	public MetaImageListProperties newInstance() {
		return new MetaImageListProperties();
	}
}
