package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
/**
 * 属性JSON基类
 * 
 * @author 陈瑞
 *
 * @param <P>
 */
public abstract class BasePropertiesJSONHandler<P extends AbstractMetaObject>{
	
	@SuppressWarnings("unchecked")
	public final JSONObject toJSON(AbstractMetaObject meta, DefaultSerializeContext hook, String key)
			throws Throwable {
		JSONObject o = new JSONObject();
		this.toJSONImpl(o, (P) meta, hook, key);
		return o;
	}
	
	public abstract void toJSONImpl(JSONObject json, P meta, DefaultSerializeContext hook, String key)
			throws Throwable;
	
	public AbstractMetaObject fromJSON(JSONObject json) throws Throwable {
		P meta = newInstance();
		this.fromJSONImpl(meta, json);
		return meta;
	}
	
	public abstract P newInstance();
	
	public abstract void fromJSONImpl(P meta, JSONObject json) throws Throwable; 
		
}
