package com.bokesoft.yes.meta.json.com.grid;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaBaseScriptJSONHandler;
import com.bokesoft.yigo.meta.form.component.grid.MetaTrace;

public class MetaTraceJSONHandler extends MetaBaseScriptJSONHandler<MetaTrace,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaTrace meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CONDITION, meta.getCondition());
	}
	
	@Override
	public void fromJSONImpl(MetaTrace meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setCondition(json.optString(JSONConstants.COMMON_CONDITION));
	}
	
	@Override
	public MetaTrace newInstance() {
		return new MetaTrace();
	}
		
}
