package com.bokesoft.yes.meta.json.com.grid;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaBaseScriptJSONHandler;
import com.bokesoft.yigo.meta.form.component.grid.MetaRowExpand;

public class MetaRowExpandJSONHandler extends MetaBaseScriptJSONHandler<MetaRowExpand,DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaRowExpand meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.GRID_EXPANDTYPE, meta.getExpandType());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_CELLKEY, meta.getCellKey());
	}
	
	@Override
	public void fromJSONImpl(MetaRowExpand meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setExpandType(json.optInt(JSONConstants.GRID_EXPANDTYPE));
		meta.setCellKey(json.optString(JSONConstants.GRID_CELLKEY));
	}
	
	@Override
	public MetaRowExpand newInstance() {
		return new MetaRowExpand();
	}

}
