package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;

public class MetaSubDetailJSONHandler extends BaseComponentJSONHandler<MetaSubDetail>{

	@Override
	public void toJSONImpl(JSONObject json, MetaSubDetail meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.SUBDETAIL_GRIDKEY, meta.getBindingGridKey());
		
		MetaComponent root = meta.getRoot();
		if( root != null ) {
			JSONObject o = UIJSONHandlerUtil.build(root,hook);
			o.put("subDetailKey", meta.getKey());
			o.put(JSONConstants.COMMON_X, meta.getX());
			o.put(JSONConstants.COMMON_Y, meta.getY());
			o.put(JSONConstants.COMPONENT_XSPAN, meta.getXSpan());
			o.put(JSONConstants.COMPONENT_YSPAN, meta.getYSpan());
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_ROOT, o);
			DefSize width = root.getWidth();
			if( width != null ) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, width.toString(), "");
			}
			
			DefSize height = root.getHeight();
			if( height != null ) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, height.toString(), "");
			}

			DefSize minHeight = root.getMinHeight();
			if( minHeight != null ) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_MINHEIGHT, minHeight.toString(), "");
			}
		}
	}
	
	@Override
	public void fromJSONImpl(MetaSubDetail meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setBindingGridKey(json.optString(JSONConstants.SUBDETAIL_GRIDKEY));
		
		JSONObject o = json.optJSONObject(JSONConstants.COMMON_ROOT);
		if( o != null ) {
			MetaComponent root = (MetaComponent) UIJSONHandlerUtil.unbuild(o);
			meta.setRoot(root);
		}
	}

	@Override
	public MetaSubDetail newInstance() {
		return new MetaSubDetail();
	}
}