package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaExtraLayout;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGroupCollection;

public class MetaExtraLayoutJSONHandler extends AbstractJSONHandler<MetaExtraLayout, DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaExtraLayout meta, DefaultSerializeContext hook) throws Throwable {
		MetaGroupCollection metaGroupCollection = meta.getMetaGroupCollection();
		if (metaGroupCollection != null) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, metaGroupCollection);
			JSONHelper.writeToJSON(json, JSONConstants.GRIDLAYOUTPANEL_GROUP_COLLECTION, array);
		} else {
			JSONHelper.writeToJSON(json, JSONConstants.GRIDLAYOUTPANEL_GROUP_COLLECTION, new JSONArray());
		}
	}

	@Override
	public MetaExtraLayout newInstance() {
		return new MetaExtraLayout();
	}

	@Override
	public void fromJSONImpl(MetaExtraLayout meta, JSONObject json) throws Throwable {
		// TODO Auto-generated method stub
		
	}

}

