package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.common.MetaCustomConditionPara;

public class MetaCustomConditionParaJSONHandler extends AbstractJSONHandler<MetaCustomConditionPara,DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaCustomConditionPara meta,
			DefaultSerializeContext hook) throws Throwable {
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.CUSTOM_CONDITION_FORMULA, meta.getFormula());
	}

	@Override
	public void fromJSONImpl(MetaCustomConditionPara meta, JSONObject json) throws Throwable {
		
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setFormula(json.optString(JSONConstants.CUSTOM_CONDITION_FORMULA));
	}

	@Override
	public MetaCustomConditionPara newInstance() {
		return new MetaCustomConditionPara();
	}
}
