package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaVisiblePerm;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaVisiblePermItem;

public class MetaVisiblePermJSONHandler extends AbstractJSONHandler<MetaVisiblePerm, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaVisiblePerm meta, JSONObject json) throws Throwable {
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if(array != null){
			meta.addAll(BPMJSONHandlerUtil.unbuild(MetaVisiblePermItem.class, array));
		}
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaVisiblePerm meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		
		JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
		
	}
	
	@Override
	public MetaVisiblePerm newInstance() {
		return new MetaVisiblePerm();
	}
}
