package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaAssistanceCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaAutoCommitItem;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaAutoCommitItemCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaAutoIgnoreExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMOperation;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMOperationExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaCreateTriggerExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaFinishTriggerExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaOperationCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaDictionary;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaMidFormula;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaParticipatorCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaQuery;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelation;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerAutoAbstain;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerAutoDeny;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerAutoPass;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerItem;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerItemCollection;
import com.bokesoft.yigo.meta.bpm.process.message.MetaNodeMessage;
import com.bokesoft.yigo.meta.bpm.process.node.MetaAudit;
import com.bokesoft.yigo.meta.bpm.process.node.MetaCountersign;
import com.bokesoft.yigo.meta.bpm.process.node.MetaUserTask;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPerm;

public class MetaUserTaskJSONHandler<T extends MetaUserTask> extends MetaNodeJSONHandler<T> {

	@Override
	public void fromJSONImpl(T meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setCreateTrigger(json.optString(JSONConstants.NODE_CREATE_TRIGGER));
		meta.setFinishTrigger(json.optString(JSONConstants.NODE_FINISH_TRIGGER));
		meta.setFormKey(json.optString(JSONConstants.FORM_KEY));
		meta.setStatus(json.optString(JSONConstants.NODE_STATUS));
		meta.setAutoIgnoreNoParticipator(json.optBoolean(JSONConstants.NODE_AUTO_IGNORE));
		meta.setAutoCommitSameParticipator(json.optBoolean(JSONConstants.NODE_AUTO_COMMIT));
		meta.setAutoCommitContainSameParticipator(json.optBoolean(JSONConstants.NODE_AUTO_COMMIT_CONTAIN));
		
		JSONArray array = json.optJSONArray(JSONConstants.BPM_OPERATIONCOLLECTION);
		if(array != null){
			MetaOperationCollection operationCollection = new MetaOperationCollection();
			for( int i = 0,size = array.length();i < size;i++ ) {
				JSONObject jsonObject = array.getJSONObject(i);
				String tagName = jsonObject.optString(JSONConstants.BPM_TAGNAME);
				if(MetaBPMOperation.TAG_NAME.equalsIgnoreCase(tagName)){
					operationCollection.add(BPMJSONHandlerUtil.unbuild(MetaBPMOperation.class, jsonObject));
				}else if(MetaBPMOperationExternalLink.TAG_NAME.equalsIgnoreCase(tagName)){
					operationCollection.add(BPMJSONHandlerUtil.unbuild(MetaBPMOperationExternalLink.class, jsonObject));
				}
			}
			meta.setOperationCollection(operationCollection);
		}
		array = json.optJSONArray(JSONConstants.BPM_ASSISTANCECOLLECTION);
		if(array != null){
			MetaAssistanceCollection assistanceCollection = new MetaAssistanceCollection();
			for( int i = 0,size = array.length();i < size;i++ ) {
				JSONObject jsonObject = array.getJSONObject(i);
				String tagName = jsonObject.optString(JSONConstants.BPM_TAGNAME);
				if(MetaAudit.TAG_NAME.equalsIgnoreCase(tagName)){
					assistanceCollection.add(BPMJSONHandlerUtil.unbuild(MetaAudit.class, jsonObject));
				}else if(MetaCountersign.TAG_NAME.equalsIgnoreCase(tagName)){
					assistanceCollection.add(BPMJSONHandlerUtil.unbuild(MetaCountersign.class, jsonObject));
				}else if(MetaUserTask.TAG_NAME.equalsIgnoreCase(tagName)){
					assistanceCollection.add(BPMJSONHandlerUtil.unbuild(MetaUserTask.class, jsonObject));
				}
			}
			meta.setAssistanceCollection(assistanceCollection);
		}
		array = json.optJSONArray(JSONConstants.BPM_PARTICIPATORCOLLECTION);
		if(array != null){
			MetaParticipatorCollection participatorCollection = new MetaParticipatorCollection();
			for( int i = 0,size = array.length();i < size;i++ ) {
				JSONObject jsonObject = array.getJSONObject(i);
				String tagName = jsonObject.optString(JSONConstants.BPM_TAGNAME);
				if(MetaDictionary.TAG_NAME.equalsIgnoreCase(tagName)){
					participatorCollection.add(BPMJSONHandlerUtil.unbuild(MetaDictionary.class, jsonObject));
				}else if(MetaMidFormula.TAG_NAME.equalsIgnoreCase(tagName)){
					participatorCollection.add(BPMJSONHandlerUtil.unbuild(MetaMidFormula.class, jsonObject));
				}else if(MetaQuery.TAG_NAME.equalsIgnoreCase(tagName)){
					participatorCollection.add(BPMJSONHandlerUtil.unbuild(MetaQuery.class, jsonObject));
				}else if(MetaRelation.TAG_NAME.equalsIgnoreCase(tagName)){
					participatorCollection.add(BPMJSONHandlerUtil.unbuild(MetaRelation.class, jsonObject));
				}else if(MetaExternalLink.TAG_NAME.equalsIgnoreCase(tagName)){
					participatorCollection.add(BPMJSONHandlerUtil.unbuild(MetaExternalLink.class, jsonObject));
				}
			}
			meta.setParticipatorCollection(participatorCollection);
		}
		array = json.optJSONArray(JSONConstants.BPM_TIMERITEMCOLLECTION);
		if(array != null){
			MetaTimerItemCollection timerItemCollection = new MetaTimerItemCollection();
			for( int i = 0,size = array.length();i < size;i++ ) {
				JSONObject jsonObject = array.getJSONObject(i);
				String tagName = jsonObject.optString(JSONConstants.BPM_TAGNAME);
				if(MetaTimerItem.TAG_NAME.equalsIgnoreCase(tagName)){
					timerItemCollection.add(BPMJSONHandlerUtil.unbuild(MetaTimerItem.class, jsonObject));
				}else if(MetaTimerAutoAbstain.TAG_NAME.equalsIgnoreCase(tagName)){
					timerItemCollection.add(BPMJSONHandlerUtil.unbuild(MetaTimerAutoAbstain.class, jsonObject));
				}else if(MetaTimerAutoDeny.TAG_NAME.equalsIgnoreCase(tagName)){
					timerItemCollection.add(BPMJSONHandlerUtil.unbuild(MetaTimerAutoDeny.class, jsonObject));
				}else if(MetaTimerAutoPass.TAG_NAME.equalsIgnoreCase(tagName)){
					timerItemCollection.add(BPMJSONHandlerUtil.unbuild(MetaTimerAutoPass.class, jsonObject));
				}else if(MetaTimerExternalLink.TAG_NAME.equalsIgnoreCase(tagName)){
					timerItemCollection.add(BPMJSONHandlerUtil.unbuild(MetaTimerExternalLink.class, jsonObject));
				}
			}
			meta.setTimerItemCollection(timerItemCollection);
		}
		JSONObject o = json.optJSONObject(JSONConstants.BPM_PERM);
		if(o != null){
			MetaPerm perm = BPMJSONHandlerUtil.unbuild(MetaPerm.class, o);
			meta.setPerm(perm);
		}
		o = json.optJSONObject(JSONConstants.BPM_NODEMESSAGE);
		if(o != null){
			MetaNodeMessage nodeMessage = BPMJSONHandlerUtil.unbuild(MetaNodeMessage.class, o);
			meta.setNodeMessage(nodeMessage);
		}
		array = json.optJSONArray(JSONConstants.BPM_AUTOCOMMITITEMCOLLECTION);
		if(array != null){
			MetaAutoCommitItemCollection autoCommitItemCollection = new MetaAutoCommitItemCollection();
			autoCommitItemCollection.addAll(0, BPMJSONHandlerUtil.unbuild(MetaAutoCommitItem.class, array));
			meta.setAutoCommitItemCollection(autoCommitItemCollection);
		}
		o = json.optJSONObject(JSONConstants.BPM_CREATETRIGGEREXTERNALLINK);
		if(o != null){
			MetaCreateTriggerExternalLink createTriggerExternalLink = BPMJSONHandlerUtil.unbuild(MetaCreateTriggerExternalLink.class, o);
			meta.setCreateTriggerExternalLink(createTriggerExternalLink);
		}
		o = json.optJSONObject(JSONConstants.BPM_FINISHTRIGGEREXTERNALLINK);
		if(o != null){
			MetaFinishTriggerExternalLink finishTriggerExternalLink = BPMJSONHandlerUtil.unbuild(MetaFinishTriggerExternalLink.class, o);
			meta.setFinishTriggerExternalLink(finishTriggerExternalLink);
		}
		o = json.optJSONObject(JSONConstants.BPM_AUTOIGNOREEXTERNALLINK);
		if(o != null){
			MetaAutoIgnoreExternalLink autoIgnoreExternalLink = BPMJSONHandlerUtil.unbuild(MetaAutoIgnoreExternalLink.class, o);
			meta.setAutoIgnoreExternalLink(autoIgnoreExternalLink);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, T meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.NODE_CREATE_TRIGGER, meta.getCreateTrigger());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_FINISH_TRIGGER, meta.getFinishTrigger());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_KEY, meta.getFormKey());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_STATUS, meta.getStatus());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_AUTO_IGNORE, meta.isAutoIgnoreNoParticipator());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_AUTO_COMMIT, meta.isAutoCommitSameParticipator());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_AUTO_COMMIT_CONTAIN, meta.isAutoCommitContainSameParticipator());
		
		MetaOperationCollection operationCollection = meta.getOperationCollection();
		if(operationCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, operationCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_OPERATIONCOLLECTION, array);
		}
		MetaAssistanceCollection assistanceCollection = meta.getAssistanceCollection();
		if(assistanceCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, assistanceCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_ASSISTANCECOLLECTION, array);
		}
		MetaParticipatorCollection participatorCollection = meta.getParticipatorCollection();
		if(participatorCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, participatorCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_PARTICIPATORCOLLECTION, array);
		}
		MetaTimerItemCollection timerItemCollection = meta.getTimerItemCollection();
		if(timerItemCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, timerItemCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_TIMERITEMCOLLECTION, array);
		}
		MetaPerm perm = meta.getPerm();
		if(perm != null){
			JSONObject o = BPMJSONHandlerUtil.build(perm, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_PERM, o);
		}
		MetaNodeMessage nodeMessage = meta.getNodeMessage();
		if(nodeMessage != null){
			JSONObject o = BPMJSONHandlerUtil.build(nodeMessage, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_NODEMESSAGE, o);
		}
		MetaAutoCommitItemCollection autoCommitItemCollection = meta.getMetaAutoCommitItemCollection();
		if(autoCommitItemCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, autoCommitItemCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_AUTOCOMMITITEMCOLLECTION, array);
		}
		MetaCreateTriggerExternalLink createTriggerExternalLink = meta.getCreateTriggerExternalLink();
		if(createTriggerExternalLink != null){
			JSONObject o = BPMJSONHandlerUtil.build(createTriggerExternalLink, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_CREATETRIGGEREXTERNALLINK, o);
		}
		MetaFinishTriggerExternalLink finishTriggerExternalLink = meta.getFinishTriggerExternalLink();
		if(finishTriggerExternalLink != null){
			JSONObject o = BPMJSONHandlerUtil.build(finishTriggerExternalLink, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_FINISHTRIGGEREXTERNALLINK, o);
		}
		MetaAutoIgnoreExternalLink autoIgnoreExternalLink = meta.getAutoIgnoreExternalLink();
		if(autoIgnoreExternalLink != null){
			JSONObject o = BPMJSONHandlerUtil.build(autoIgnoreExternalLink, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_AUTOIGNOREEXTERNALLINK, o);
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public T newInstance() {
		return (T) new MetaUserTask();
	}
}
