package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.node.MetaServiceTask;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaServiceTaskJSONHandler extends MetaNodeJSONHandler<MetaServiceTask>{

	@Override
	public void fromJSONImpl(MetaServiceTask meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		String s = json.optString(JSONConstants.NODE_ACTION);
		if(s.length() > 0){
			MetaBaseScript action = new MetaBaseScript(BPMConstants.NODE_ACTION);
			action.setContent(s);
			meta.setAction(action);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaServiceTask meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		MetaBaseScript action = meta.getAction();
		if(action != null){
			JSONHelper.writeToJSON(json, JSONConstants.NODE_ACTION, action.getContent().trim());
		}
	}
	
	@Override
	public MetaServiceTask newInstance() {
		return new MetaServiceTask();
	}
}
