package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaQuery;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaQueryParameter;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaQueryParameterCollection;

public class MetaQueryJSONHandler extends AbstractJSONHandler<MetaQuery, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaQuery meta, JSONObject json) throws Throwable {
		meta.setSQL(json.optString(JSONConstants.BPM_SQL));
		
		JSONArray array = json.optJSONArray(JSONConstants.BPM_QUERYPARAMETERCOLLECTION);
		if(array != null){
			MetaQueryParameterCollection queryParameterCollection = new MetaQueryParameterCollection();
			queryParameterCollection.addAll(0, BPMJSONHandlerUtil.unbuild(MetaQueryParameter.class, array));
			meta.setQueryParameterCollection(queryParameterCollection);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaQuery meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.BPM_SQL, meta.getSQL());
		
		MetaQueryParameterCollection queryParameterCollection = meta.getQueryParameterCollection();
		if(queryParameterCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, queryParameterCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_QUERYPARAMETERCOLLECTION, array);
		}
		
	}
	
	@Override
	public MetaQuery newInstance() {
		return new MetaQuery();
	}
}
