package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.message.MetaProducer;

public class MetaProducerJSONHandler extends AbstractJSONHandler<MetaProducer, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaProducer meta, JSONObject json) throws Throwable {
		meta.setDestination(json.optString(JSONConstants.MESSAGE_DESTINATION));
		meta.setMessageSendImpl(json.optString(JSONConstants.NODE_MESSAGE_SEND_IMPL));
		meta.setResendTimes(json.optInt(JSONConstants.MESSAGE_RESENDTIMES));
		meta.setTimeout(json.optLong(JSONConstants.MESSAGE_TIMEOUT));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaProducer meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.MESSAGE_DESTINATION, meta.getDestination());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_MESSAGE_SEND_IMPL, meta.getMessageSendImpl());
		JSONHelper.writeToJSON(json, JSONConstants.MESSAGE_RESENDTIMES, meta.getResendTimes());
		JSONHelper.writeToJSON(json, JSONConstants.MESSAGE_TIMEOUT, meta.getTimeout());
		
	}
	
	@Override
	public MetaProducer newInstance() {
		return new MetaProducer();
	}
}
