package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaDictionary;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaMidFormula;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaParticipatorCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaQuery;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelation;

public class MetaParticipatorCollectionJSONHandler extends AbstractJSONHandler<MetaParticipatorCollection, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaParticipatorCollection meta, JSONObject json) throws Throwable {
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if(array != null){
			for( int i = 0,size = array.length();i < size;i++ ) {
				JSONObject jsonObject = array.getJSONObject(i);
				String tagName = jsonObject.optString(JSONConstants.BPM_TAGNAME);
				if(MetaDictionary.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaDictionary.class, jsonObject));
				}else if(MetaMidFormula.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaMidFormula.class, jsonObject));
				}else if(MetaQuery.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaQuery.class, jsonObject));
				}else if(MetaRelation.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaRelation.class, jsonObject));
				}else if(MetaExternalLink.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaExternalLink.class, jsonObject));
				}
			}
		}
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaParticipatorCollection meta, BPMSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		
		JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
		
	}
	
	@Override
	public MetaParticipatorCollection newInstance() {
		return new MetaParticipatorCollection();
	}
}
