package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.node.MetaInline;

public class MetaInlineJSONHandler extends MetaNodeJSONHandler<MetaInline> {

	@Override
	public void fromJSONImpl(MetaInline meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setInlineProcessKey(json.optString(JSONConstants.NODE_INLINE_PROCESS_KEY));
		meta.setProcessKeyFormula(json.optString(JSONConstants.NODE_INLINE_PROCESS_KEY_FORMULA));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaInline meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.NODE_INLINE_PROCESS_KEY, meta.getInlineProcessKey());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_INLINE_PROCESS_KEY_FORMULA, meta.getProcessKeyFormula());
	}
	
	@Override
	public MetaInline newInstance() {
		return new MetaInline();
	}
}
