package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.node.MetaCountersign;

public class MetaCountersignJSONHandler extends MetaAuditJSONHandler<MetaCountersign> {

	@Override
	public void fromJSONImpl(MetaCountersign meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setPassType(json.optInt(JSONConstants.NODE_PASS_TYPE));
		meta.setPassCondition(json.optString(JSONConstants.NODE_PASS_CONDITION));
		meta.setValidType(json.optInt(JSONConstants.NODE_VALID_TYPE));
		meta.setValidCondition(json.optString(JSONConstants.NODE_VALID_CONDITION));
		meta.setFinishType(json.optInt(JSONConstants.NODE_FINISH_TYPE));
		meta.setFinishCondition(json.optString(JSONConstants.NODE_FINISH_CONDITION));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaCountersign meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.NODE_PASS_TYPE, meta.getPassType());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_PASS_CONDITION, meta.getPassCondition());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_VALID_TYPE, meta.getValidType());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_VALID_CONDITION, meta.getValidCondition());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_FINISH_TYPE, meta.getFinishType());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_FINISH_CONDITION, meta.getFinishCondition());
	}
	
	@Override
	public MetaCountersign newInstance() {
		return new MetaCountersign();
	}
}
