package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMOperationExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaSourcePara;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaSourceParaCollection;

public class MetaBPMOperationExternalLinkJSONHandler extends AbstractJSONHandler<MetaBPMOperationExternalLink, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaBPMOperationExternalLink meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		
		JSONArray array = json.optJSONArray(JSONConstants.BPM_SOURCEPARACOLLECTION);
		if(array != null){
			MetaSourceParaCollection metaSourceParaCollection = new MetaSourceParaCollection();
			metaSourceParaCollection.addAll(0, BPMJSONHandlerUtil.unbuild(MetaSourcePara.class, array));
			meta.setSourceParaCollection(metaSourceParaCollection);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaBPMOperationExternalLink meta, BPMSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		
		MetaSourceParaCollection metaSourceParaCollection = meta.getSourceParaCollection();
		if(metaSourceParaCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, metaSourceParaCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_SOURCEPARACOLLECTION, array);
		}
		
	}
	
	@Override
	public MetaBPMOperationExternalLink newInstance() {
		return new MetaBPMOperationExternalLink();
	}
}
