package com.bokesoft.yes.meta.json;

import java.util.HashMap;

import com.bokesoft.yes.meta.json.report.MetaReportBorderJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportCategoryJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportCellTextJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportChartDataSourceJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportChartJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportColumnExpandJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportDataFieldJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportDataSourceJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportDataTableJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportDisplayJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportEmbedJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportFontJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportFormatJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportGridCellJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportGridColumnJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportGridRowJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportGridSectionHandler;
import com.bokesoft.yes.meta.json.report.MetaReportImageJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportImageStyleJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportListItemJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportRowExpandJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportRowGroupJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportSeriesJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportTextJSONHandler;
import com.bokesoft.yes.meta.json.report.MetaReportWaterprintJSONHandler;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.meta.report.MetaReportBorder;
import com.bokesoft.yigo.meta.report.MetaReportCellText;
import com.bokesoft.yigo.meta.report.MetaReportColumnExpand;
import com.bokesoft.yigo.meta.report.MetaReportDataField;
import com.bokesoft.yigo.meta.report.MetaReportDataSource;
import com.bokesoft.yigo.meta.report.MetaReportDataTable;
import com.bokesoft.yigo.meta.report.MetaReportDisplay;
import com.bokesoft.yigo.meta.report.MetaReportFont;
import com.bokesoft.yigo.meta.report.MetaReportFormat;
import com.bokesoft.yigo.meta.report.MetaReportGridCell;
import com.bokesoft.yigo.meta.report.MetaReportGridColumn;
import com.bokesoft.yigo.meta.report.MetaReportGridRow;
import com.bokesoft.yigo.meta.report.MetaReportGridSection;
import com.bokesoft.yigo.meta.report.MetaReportImageStyle;
import com.bokesoft.yigo.meta.report.MetaReportListItem;
import com.bokesoft.yigo.meta.report.MetaReportRowExpand;
import com.bokesoft.yigo.meta.report.MetaReportRowGroup;
import com.bokesoft.yigo.meta.report.MetaReportWaterprint;
import com.bokesoft.yigo.meta.report.embed.MetaReportChart;
import com.bokesoft.yigo.meta.report.embed.MetaReportEmbed;
import com.bokesoft.yigo.meta.report.embed.MetaReportImage;
import com.bokesoft.yigo.meta.report.embed.MetaReportText;
import com.bokesoft.yigo.meta.report.embed.chart.MetaReportCategory;
import com.bokesoft.yigo.meta.report.embed.chart.MetaReportChartDataSource;
import com.bokesoft.yigo.meta.report.embed.chart.MetaReportSeries;

@SuppressWarnings("rawtypes")
public class ReportJSONHandlerMap {
	private static HashMap<String, AbstractJSONHandler> handlers = null;
	
	static {
		if(handlers == null) {
			handlers = new HashMap<String, AbstractJSONHandler>();
			
			handlers.put(MetaReportBorder.TAG_NAME, new MetaReportBorderJSONHandler());
			handlers.put(MetaReportCategory.TAG_NAME, new MetaReportCategoryJSONHandler());
			handlers.put(MetaReportChartDataSource.TAG_NAME, new MetaReportChartDataSourceJSONHandler());
			handlers.put(MetaReportChart.TAG_NAME, new MetaReportChartJSONHandler());
			handlers.put(MetaReportDataField.TAG_NAME, new MetaReportDataFieldJSONHandler());
			handlers.put(MetaReportDataSource.TAG_NAME, new MetaReportDataSourceJSONHandler());
			handlers.put(MetaReportDataTable.TAG_NAME, new MetaReportDataTableJSONHandler());
			handlers.put(MetaReportDisplay.TAG_NAME, new MetaReportDisplayJSONHandler());
			handlers.put(MetaReportEmbed.TAG_NAME, new MetaReportEmbedJSONHandler());
			handlers.put(MetaReportFont.TAG_NAME, new MetaReportFontJSONHandler());
			handlers.put(MetaReportFormat.TAG_NAME, new MetaReportFormatJSONHandler());
			handlers.put(MetaReportGridColumn.TAG_NAME, new MetaReportGridColumnJSONHandler());
			handlers.put(MetaReportGridRow.TAG_NAME, new MetaReportGridRowJSONHandler());
			handlers.put(MetaReportGridSection.TAG_NAME, new MetaReportGridSectionHandler());
			handlers.put(MetaReportImage.TAG_NAME, new MetaReportImageJSONHandler());
			handlers.put(MetaReportImageStyle.TAG_NAME, new MetaReportImageStyleJSONHandler());
			handlers.put(MetaReport.TAG_NAME, new MetaReportJSONHandler());
			handlers.put(MetaReportListItem.TAG_NAME, new MetaReportListItemJSONHandler());
			handlers.put(MetaReportSeries.TAG_NAME, new MetaReportSeriesJSONHandler());
			handlers.put(MetaReportText.TAG_NAME, new MetaReportTextJSONHandler());
			handlers.put(MetaReportWaterprint.TAG_NAME, new MetaReportWaterprintJSONHandler());
			
			handlers.put(MetaReportCellText.TAG_NAME, new MetaReportCellTextJSONHandler());
			handlers.put(MetaReportColumnExpand.TAG_NAME, new MetaReportColumnExpandJSONHandler());
			handlers.put(MetaReportGridCell.TAG_NAME, new MetaReportGridCellJSONHandler());
			handlers.put(MetaReportRowExpand.TAG_NAME, new MetaReportRowExpandJSONHandler());
			handlers.put(MetaReportRowGroup.TAG_NAME, new MetaReportRowGroupJSONHandler());
			
		}
	}
	
	public static void register(String tagName, AbstractJSONHandler handler) {
		handlers.put(tagName, handler);
	}
	
	@SuppressWarnings("unchecked")
	public static AbstractJSONHandler<AbstractMetaObject,ISerializeContext> getHandler(String tagName) {
		AbstractJSONHandler<AbstractMetaObject,ISerializeContext> handler = handlers.get(tagName);
		if( handler != null ) {
			return handler;
		}
		
		// 调试
		throw new RuntimeException("报表类型: " + tagName + " 未定义json处理类");
	}
}
