package com.bokesoft.yes.meta.json;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yes.meta.json.util.SerializeNodeUtil;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.bpm.migration.MetaDMField;
import com.bokesoft.yigo.meta.bpm.migration.MetaDMTable;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.attachment.MetaAttachment;
import com.bokesoft.yigo.meta.bpm.process.attachment.MetaAttachmentCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMInfo;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMInfoCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimline;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlineCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaDictionary;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaMidFormula;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaParticipatorCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaQuery;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelation;
import com.bokesoft.yigo.meta.bpm.process.event.MetaEventCollection;
import com.bokesoft.yigo.meta.bpm.process.event.MetaEventCollectionExternalLink;
import com.bokesoft.yigo.meta.bpm.process.event.MetaEventItem;
import com.bokesoft.yigo.meta.bpm.process.expand.MetaExpand;
import com.bokesoft.yigo.meta.bpm.process.multipleform.MetaRefForm;
import com.bokesoft.yigo.meta.bpm.process.multipleform.MetaRefFormCollection;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPerm;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPermCollection;
import com.bokesoft.yigo.meta.bpm.process.perm.extend.MetaInitiatorPermCollection;

public class MetaProcessJSONHandler extends AbstractJSONHandler<MetaProcess, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaProcess meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setIdSeed(json.optInt(JSONConstants.COMMON_IDSEED));
		meta.setVersion(json.optInt(JSONConstants.COMMON_VERSION));
		meta.setFormKey(json.optString(JSONConstants.FORM_KEY));
		meta.setTemplateKey(json.optString(JSONConstants.NODE_TEMPLATEKEY));
		meta.setIgnoreFormState(json.optBoolean(JSONConstants.IGNORE_FORM_STATE));
		meta.setQueryRetreatWorkitem(json.optBoolean(JSONConstants.QUERY_RETREAT_WORKITEM));
		meta.setKillInstanceTrigger(json.optString(JSONConstants.KILL_INSTANCE_TRIGGER));
		meta.setLockWorkitem(json.optInt(JSONConstants.LOCK_WORKITEM));
		
		JSONObject o = json.optJSONObject(JSONConstants.BPM_EXPAND);
		if(o != null){
			MetaExpand metaExpand = BPMJSONHandlerUtil.unbuild(MetaExpand.class, o);
			meta.setExpand(metaExpand);
		}
		JSONArray array = json.optJSONArray(JSONConstants.BPM_SWIMLINECOLLECTION);
		if(array != null){
			MetaSwimlineCollection swimlineCollection = new MetaSwimlineCollection();
			swimlineCollection.addAll(BPMJSONHandlerUtil.unbuild(MetaSwimline.class, array));
			meta.setSwimlineCollection(swimlineCollection);
		}
		array = json.optJSONArray(JSONConstants.BPM_BPMINFOCOLLECTION);
		if(array != null){
			MetaBPMInfoCollection bpmInfoCollection = new MetaBPMInfoCollection();
			bpmInfoCollection.addAll(BPMJSONHandlerUtil.unbuild(MetaBPMInfo.class, array));
			meta.setBPMInfoCollection(bpmInfoCollection);
		}
		array = json.optJSONArray(JSONConstants.BPM_DATAMIGRATIONTABLE);
		if(array != null){
			MetaDMTable dataMigrationTable = new MetaDMTable();
			dataMigrationTable.addAll(BPMJSONHandlerUtil.unbuild(MetaDMField.class, array));
			meta.setDataMigrationTable(dataMigrationTable);
		}
		array = json.optJSONArray(JSONConstants.BPM_PERMCOLLECTION);
		if(array != null){
			MetaPermCollection permCollection = new MetaPermCollection();
			permCollection.addAll(0, BPMJSONHandlerUtil.unbuild(MetaPerm.class, array));
			meta.setPermCollection(permCollection);
		}
		array = json.optJSONArray(JSONConstants.BPM_INITIATORPERMCOLLECTION);
		if(array != null){
			MetaInitiatorPermCollection initiatorPermCollection = new MetaInitiatorPermCollection();
			initiatorPermCollection.addAll(0, BPMJSONHandlerUtil.unbuild(MetaPerm.class, array));
			meta.setInitiatorPermCollection(initiatorPermCollection);
		}
		array = json.optJSONArray(JSONConstants.BPM_ATTACHMENTCOLLECTION);
		if(array != null){
			MetaAttachmentCollection attachmentCollection = new MetaAttachmentCollection();
			attachmentCollection.addAll(BPMJSONHandlerUtil.unbuild(MetaAttachment.class, array));
			meta.setAttachmentCollection(attachmentCollection);
		}
		array = json.optJSONArray(JSONConstants.BPM_GLOBALPTORCOLLECTION);
		if(array != null){
			MetaParticipatorCollection globalptorCollection = new MetaParticipatorCollection();
			for( int i = 0,size = array.length();i < size;i++ ) {
				JSONObject jsonObject = array.getJSONObject(i);
				String tagName = jsonObject.optString(JSONConstants.BPM_TAGNAME);
				if(MetaDictionary.TAG_NAME.equalsIgnoreCase(tagName)){
					globalptorCollection.add(BPMJSONHandlerUtil.unbuild(MetaDictionary.class, jsonObject));
				}else if(MetaMidFormula.TAG_NAME.equalsIgnoreCase(tagName)){
					globalptorCollection.add(BPMJSONHandlerUtil.unbuild(MetaMidFormula.class, jsonObject));
				}else if(MetaQuery.TAG_NAME.equalsIgnoreCase(tagName)){
					globalptorCollection.add(BPMJSONHandlerUtil.unbuild(MetaQuery.class, jsonObject));
				}else if(MetaRelation.TAG_NAME.equalsIgnoreCase(tagName)){
					globalptorCollection.add(BPMJSONHandlerUtil.unbuild(MetaRelation.class, jsonObject));
				}else if(MetaExternalLink.TAG_NAME.equalsIgnoreCase(tagName)){
					globalptorCollection.add(BPMJSONHandlerUtil.unbuild(MetaExternalLink.class, jsonObject));
				}
			}
			meta.setGlobeptorsCollection(globalptorCollection);
		}
		array = json.optJSONArray(JSONConstants.BPM_EVENTCOLLECTION);
		if(array != null){
			MetaEventCollection eventCollection = new MetaEventCollection();
			for( int i = 0,size = array.length();i < size;i++ ) {
				JSONObject jsonObject = array.getJSONObject(i);
				String tagName = jsonObject.optString(JSONConstants.BPM_TAGNAME);
				if(MetaEventItem.TAG_NAME.equalsIgnoreCase(tagName)){
					eventCollection.add(BPMJSONHandlerUtil.unbuild(MetaEventItem.class, jsonObject));
				}else if(MetaEventCollectionExternalLink.TAG_NAME.equalsIgnoreCase(tagName)){
					eventCollection.add(BPMJSONHandlerUtil.unbuild(MetaEventCollectionExternalLink.class, jsonObject));
				}
			}
			meta.setEventCollection(eventCollection);
		}
		array = json.optJSONArray(JSONConstants.BPM_REFFORMCOLLECTION);
		if(array != null){
			MetaRefFormCollection refFormCollection = new MetaRefFormCollection();
			refFormCollection.addAll(BPMJSONHandlerUtil.unbuild(MetaRefForm.class, array));
			meta.setRefFormCollection(refFormCollection);
		}
		
		array = json.optJSONArray(JSONConstants.BPM_NODES);
		if(array != null){
			List<MetaNode> list = SerializeNodeUtil.unbuildNodes(array);
			meta.addAll(list);
		}
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaProcess meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		String caption = hook.getProcessString(GroupKeyTable.STR_BPM_NODE, meta.getKey(), meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, caption);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_IDSEED, meta.getIdSeed());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VERSION, meta.getVersion());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_KEY, meta.getFormKey());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_TEMPLATEKEY, meta.getTemplateKey());
		JSONHelper.writeToJSON(json, JSONConstants.IGNORE_FORM_STATE, meta.getIgnoreFormState());
		JSONHelper.writeToJSON(json, JSONConstants.QUERY_RETREAT_WORKITEM, meta.getQueryRetreatWorkitem());
		JSONHelper.writeToJSON(json, JSONConstants.KILL_INSTANCE_TRIGGER, meta.getKillInstanceTrigger());
		JSONHelper.writeToJSON(json, JSONConstants.LOCK_WORKITEM, meta.getLockWorkitem());
		
		MetaExpand metaExpand = meta.getExpand();
		if(metaExpand != null){
			JSONObject o = BPMJSONHandlerUtil.build(metaExpand, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_EXPAND, o);
		}
		MetaSwimlineCollection swimlineCollection = meta.getSwimlineCollection();
		if(swimlineCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, swimlineCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_SWIMLINECOLLECTION, array);
		}
		MetaBPMInfoCollection bpmInfoCollection = meta.getBPMInfoCollection();
		if(bpmInfoCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, bpmInfoCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_BPMINFOCOLLECTION, array);
		}
		MetaDMTable dataMigrationTable = meta.getDataMigrationTable();
		if(dataMigrationTable != null){
			JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, dataMigrationTable);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_DATAMIGRATIONTABLE, array);
		}
		MetaPermCollection permCollection = meta.getPermCollection();
		if(permCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, permCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_PERMCOLLECTION, array);
		}
		MetaInitiatorPermCollection initiatorPermCollection = meta.getInitiatorPermCollection();
		if(initiatorPermCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, initiatorPermCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_INITIATORPERMCOLLECTION, array);
		}
		MetaAttachmentCollection attachmentCollection = meta.getAttachmentCollection();
		if(attachmentCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, attachmentCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_ATTACHMENTCOLLECTION, array);
		}
		MetaParticipatorCollection globalptorCollection = meta.getGlobeptorsCollection();
		if(globalptorCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, globalptorCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_GLOBALPTORCOLLECTION, array);
		}
		MetaEventCollection eventCollection = meta.getEventCollection();
		if(eventCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, eventCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_EVENTCOLLECTION, array);
		}
		MetaRefFormCollection refFormCollection = meta.getRefFormCollection();
		if(refFormCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, refFormCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_REFFORMCOLLECTION, array);
		}
		
		JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.BPM_NODES, array);
		
	}
	
	@Override
	public MetaProcess newInstance() {
		return new MetaProcess();
	}
}
