package com.bokesoft.yes.meta.json;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.tools.ve.IVEHost;

public class MetaFormJsonSerializer {
	private MetaForm metaForm = null;
	
	private IVEHost veHost = null;
	
	public MetaFormJsonSerializer(MetaForm metaForm,IVEHost veHost) {
		this.metaForm = metaForm;
		this.veHost = veHost;
	}

	public void setVEHost(IVEHost veHost) {
		this.veHost = veHost;
	}

	public JSONObject serialize() throws Throwable {		
		AbstractJSONHandler<AbstractMetaObject,ISerializeContext> handler = UIJSONHandlerMap.getHandler(MetaForm.TAG_NAME);
				
		return handler.toJSON(metaForm, new DefaultSerializeContext(metaForm,veHost.getVE()));
	}
}
