package com.bokesoft.yes.meta.json;

import java.util.HashMap;

import com.bokesoft.yes.meta.json.bpm.*;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.bpm.migration.MetaDMField;
import com.bokesoft.yigo.meta.bpm.migration.MetaDMTable;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.attachment.MetaAttachment;
import com.bokesoft.yigo.meta.bpm.process.attachment.MetaAttachmentCollection;
import com.bokesoft.yigo.meta.bpm.process.attachment.MetaNodeAttachment;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaAssistanceCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaAutoCommitItem;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaAutoCommitItemCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaAutoIgnoreExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMInfo;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMInfoCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMOperation;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMOperationExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBillDataMapInfo;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBillDataMapInfoCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaConditonExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaCreateTriggerExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaDirectAuditCondition;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaFinishTriggerExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaNodeGraphic;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaOperationCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaPreCondition;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimline;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlineCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlinePosition;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlineSize;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaTableTrigger;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaTransitionGraphic;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaDictionary;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaLineCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaMidFormula;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaParticipatorCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaQuery;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaQueryParameter;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaQueryParameterCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelation;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelationLine;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelationNode;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelationNodeCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaSourcePara;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaSourceParaCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerAutoAbstain;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerAutoDeny;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerAutoPass;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerItem;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerItemCollection;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataItem;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataItemCollection;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataSpecification;
import com.bokesoft.yigo.meta.bpm.process.event.MetaEventCollection;
import com.bokesoft.yigo.meta.bpm.process.event.MetaEventCollectionExternalLink;
import com.bokesoft.yigo.meta.bpm.process.event.MetaEventItem;
import com.bokesoft.yigo.meta.bpm.process.expand.MetaExpand;
import com.bokesoft.yigo.meta.bpm.process.message.MetaConsumer;
import com.bokesoft.yigo.meta.bpm.process.message.MetaMessage;
import com.bokesoft.yigo.meta.bpm.process.message.MetaMessageCollection;
import com.bokesoft.yigo.meta.bpm.process.message.MetaNodeMessage;
import com.bokesoft.yigo.meta.bpm.process.message.MetaProducer;
import com.bokesoft.yigo.meta.bpm.process.multipleform.MetaRefForm;
import com.bokesoft.yigo.meta.bpm.process.multipleform.MetaRefFormCollection;
import com.bokesoft.yigo.meta.bpm.process.node.MetaAnchor;
import com.bokesoft.yigo.meta.bpm.process.node.MetaAudit;
import com.bokesoft.yigo.meta.bpm.process.node.MetaBegin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaBranchEnd;
import com.bokesoft.yigo.meta.bpm.process.node.MetaComplexJoin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaCountersign;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDataInput;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDataMap;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDataOutput;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDecision;
import com.bokesoft.yigo.meta.bpm.process.node.MetaEnd;
import com.bokesoft.yigo.meta.bpm.process.node.MetaEvent;
import com.bokesoft.yigo.meta.bpm.process.node.MetaExclusiveFork;
import com.bokesoft.yigo.meta.bpm.process.node.MetaExclusiveJoin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaFork;
import com.bokesoft.yigo.meta.bpm.process.node.MetaGateWay;
import com.bokesoft.yigo.meta.bpm.process.node.MetaInline;
import com.bokesoft.yigo.meta.bpm.process.node.MetaJoin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaManualTask;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMessageReceive;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMessageSend;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMultiAudit;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMultiUserTask;
import com.bokesoft.yigo.meta.bpm.process.node.MetaServiceTask;
import com.bokesoft.yigo.meta.bpm.process.node.MetaState;
import com.bokesoft.yigo.meta.bpm.process.node.MetaStateAction;
import com.bokesoft.yigo.meta.bpm.process.node.MetaSubProcess;
import com.bokesoft.yigo.meta.bpm.process.node.MetaTimer;
import com.bokesoft.yigo.meta.bpm.process.node.MetaUserTask;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaEnablePerm;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaEnablePermItem;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaOptPerm;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaOptPermItem;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPerm;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPermCollection;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPermExternalLink;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaVisiblePerm;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaVisiblePermItem;
import com.bokesoft.yigo.meta.bpm.process.perm.extend.MetaInitiatorPermCollection;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaAssociation;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaDefaultSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaExceptionFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransitionCollection;
import com.bokesoft.yigo.meta.timer.MetaTimerTask;
import com.bokesoft.yigo.meta.timer.action.TimerMidFormula;
import com.bokesoft.yigo.meta.timer.action.TimerSeDevClass;
import com.bokesoft.yigo.meta.timer.action.TimerWorkitemCommit;
import com.bokesoft.yigo.meta.timer.period.Moment;
import com.bokesoft.yigo.meta.timer.period.WorkDay;

@SuppressWarnings("rawtypes")
public class BPMJSONHandlerMap {

	private static HashMap<String, AbstractJSONHandler> handlers = null;
	
	static{
		if(handlers == null) {
			handlers = new HashMap<String, AbstractJSONHandler>();
			
			handlers.put(MetaProcess.TAG_NAME, new MetaProcessJSONHandler());
			handlers.put(MetaSwimlineCollection.TAG_NAME, new MetaSwimlineCollectionJSONHandler());
			handlers.put(MetaSwimline.TAG_NAME, new MetaSwimlineJSONHandler());
			handlers.put(MetaSwimlinePosition.TAG_NAME, new MetaSwimlinePositionJSONHandler());
			handlers.put(MetaSwimlineSize.TAG_NAME, new MetaSwimlineSizeJSONHandler());
			handlers.put(MetaBPMInfoCollection.TAG_NAME, new MetaBPMInfoCollectionJSONHandler());
			handlers.put(MetaBPMInfo.TAG_NAME, new MetaBPMInfoJSONHandler());
			handlers.put(MetaDMTable.TAG_NAME, new MetaDMTableJSONHandler());
			handlers.put(MetaDMField.TAG_NAME, new MetaDMFieldJSONHandler());
			handlers.put(MetaPermCollection.TAG_NAME, new MetaPermCollectionJSONHandler());
			handlers.put(MetaInitiatorPermCollection.TAG_NAME, new MetaInitiatorPermCollectionJSONHandler());
			handlers.put(MetaPerm.TAG_NAME, new MetaPermJSONHandler());
			handlers.put(MetaVisiblePerm.TAG_NAME, new MetaVisiblePermJSONHandler());
			handlers.put(MetaVisiblePermItem.TAG_NAME, new MetaVisiblePermItemJSONHandler());
			handlers.put(MetaEnablePerm.TAG_NAME, new MetaEnablePermJSONHandler());
			handlers.put(MetaEnablePermItem.TAG_NAME, new MetaEnablePermItemJSONHandler());
			handlers.put(MetaOptPerm.TAG_NAME, new MetaOptPermJSONHandler());
			handlers.put(MetaOptPermItem.TAG_NAME, new MetaOptPermItemJSONHandler());
			handlers.put(MetaPermExternalLink.TAG_NAME, new MetaPermExternalLinkJSONHandler());
			handlers.put(MetaSourceParaCollection.TAG_NAME, new MetaSourceParaCollectionJSONHandler());
			handlers.put(MetaSourcePara.TAG_NAME, new MetaSourceParaJSONHandler());
			handlers.put(MetaAttachmentCollection.TAG, new MetaAttachmentCollectionJSONHandler());
			handlers.put(MetaAttachment.TAG, new MetaAttachmentJSONHandler());
			handlers.put(MetaParticipatorCollection.TAG_NAME, new MetaParticipatorCollectionJSONHandler());
			handlers.put(MetaDictionary.TAG_NAME, new MetaDictionaryJSONHandler());
			handlers.put(MetaMidFormula.TAG_NAME, new MetaMidFormulaJSONHandler());
			handlers.put(MetaQuery.TAG_NAME, new MetaQueryJSONHandler());
			handlers.put(MetaQueryParameterCollection.TAG_NAME, new MetaQueryParameterCollectionJSONHandler());
			handlers.put(MetaQueryParameter.TAG_NAME, new MetaQueryParameterJSONHandler());
			handlers.put(MetaRelation.TAG_NAME, new MetaRelationJSONHandler());
			handlers.put(MetaRelationNodeCollection.TAG_NAME, new MetaRelationNodeCollectionJSONHandler());
			handlers.put(MetaRelationNode.TAG_NAME, new MetaRelationNodeJSONHandler());
			handlers.put(MetaLineCollection.TAG_NAME, new MetaLineCollectionJSONHandler());
			handlers.put(MetaRelationLine.TAG_NAME, new MetaRelationLineJSONHandler());
			handlers.put(MetaExternalLink.TAG_NAME, new MetaExternalLinkJSONHandler());
			handlers.put(MetaEventCollection.TAG_NAME, new MetaEventCollectionJSONHandler());
			handlers.put(MetaEventItem.TAG_NAME, new MetaEventItemJSONHandler());
			handlers.put(MetaEventCollectionExternalLink.TAG_NAME, new MetaEventCollectionExternalLinkJSONHandler());
			handlers.put(MetaRefFormCollection.TAG_NAME, new MetaRefFormCollectionJSONHandler());
			handlers.put(MetaRefForm.TAG_NAME, new MetaRefFormJSONHandler());
			handlers.put(MetaTransitionCollection.TAG_NAME, new MetaTransitionCollectionJSONHandler());
			handlers.put(MetaTransitionGraphic.TAG_NAME, new MetaTransitionGraphicJSONHandler());
			handlers.put(MetaSequenceFlow.TAG_NAME, new MetaSequenceFlowJSONHandler());
			handlers.put(MetaExceptionFlow.TAG_NAME, new MetaExceptionFlowJSONHandler());
			handlers.put(MetaAssociation.TAG_NAME, new MetaAssociationJSONHandler());
			handlers.put(MetaDataSpecification.TAG_NAME, new MetaDataSpecificationJSONHandler());
			handlers.put(MetaDataInput.TAG_NAME, new MetaDataInputJSONHandler());
			handlers.put(MetaDataItemCollection.TAG_NAME, new MetaDataItemCollectionJSONHandler());
			handlers.put(MetaDataItem.TAG_NAME, new MetaDataItemJSONHandler());
			handlers.put(MetaDataOutput.TAG_NAME, new MetaDataOutputJSONHandler());
			handlers.put(MetaNodeGraphic.TAG_NAME, new MetaNodeGraphicJSONHandler());
			handlers.put(MetaNodeAttachment.TAG, new MetaNodeAttachmentJSONHandler());
			handlers.put(MetaUserTask.TAG_NAME, new MetaUserTaskJSONHandler());
			handlers.put(MetaOperationCollection.TAG_NAME, new MetaOperationCollectionJSONHandler());
			handlers.put(MetaBPMOperation.TAG_NAME, new MetaBPMOperationJSONHandler());
			handlers.put(MetaBPMOperation.BATCH_TAG_NAME, new MetaBPMOperationJSONHandler());
			handlers.put(MetaBPMOperationExternalLink.TAG_NAME, new MetaBPMOperationExternalLinkJSONHandler());
			handlers.put(MetaAssistanceCollection.TAG_NAME, new MetaAssistanceCollectionJSONHandler());
			handlers.put(MetaTimerItemCollection.TAG_NAME, new MetaTimerItemCollectionJSONHandler());
			handlers.put(MetaTimerItem.TAG_NAME, new MetaTimerItemJSONHandler());
			handlers.put(MetaTimerAutoAbstain.TAG_NAME, new MetaTimerAutoAbstainJSONHandler());
			handlers.put(MetaTimerAutoDeny.TAG_NAME, new MetaTimerAutoDenyJSONHandler());
			handlers.put(MetaTimerAutoPass.TAG_NAME, new MetaTimerAutoPassJSONHandler());
			handlers.put(MetaTimerExternalLink.TAG_NAME, new MetaTimerExternalLinkJSONHandler());
			handlers.put(MetaNodeMessage.TAG_NAME, new MetaNodeMessageJSONHandler());
			handlers.put(MetaProducer.TAG_NAME, new MetaProducerJSONHandler());
			handlers.put(MetaConsumer.TAG_NAME, new MetaConsumerJSONHandler());
			handlers.put(MetaAutoCommitItemCollection.TAG_NAME, new MetaAutoCommitItemCollectionJSONHandler());
			handlers.put(MetaAutoCommitItem.TAG_NAME, new MetaAutoCommitItemJSONHandler());
			handlers.put(MetaCreateTriggerExternalLink.TAG_NAME, new MetaCreateTriggerExternalLinkJSONHandler());
			handlers.put(MetaFinishTriggerExternalLink.TAG_NAME, new MetaFinishTriggerExternalLinkJSONHandler());
			handlers.put(MetaAutoIgnoreExternalLink.TAG_NAME, new MetaAutoIgnoreExternalLinkJSONHandler());
			handlers.put(MetaAudit.TAG_NAME, new MetaAuditJSONHandler());
			handlers.put(MetaDirectAuditCondition.TAG, new MetaDirectAuditConditionJSONHandler());
			handlers.put(MetaTableTrigger.TAG, new MetaTableTriggerJSONHandler());
			handlers.put(MetaBegin.TAG_NAME, new MetaBeginJSONHandler());
			handlers.put(MetaCountersign.TAG_NAME, new MetaCountersignJSONHandler());
			handlers.put(MetaDecision.TAG_NAME, new MetaDecisionJSONHandler());
			handlers.put(MetaConditonExternalLink.TAG_NAME, new MetaConditonExternalLinkJSONHandler());
			handlers.put(MetaEnd.TAG_NAME, new MetaEndJSONHandler());
			handlers.put(MetaEvent.TAG_NAME, new MetaEventJSONHandler());
			handlers.put(MetaFork.TAG_NAME, new MetaForkJSONHandler());
			handlers.put(MetaJoin.TAG_NAME, new MetaJoinJSONHandler());
			handlers.put(MetaState.TAG_NAME, new MetaStateJSONHandler());
			handlers.put(MetaSubProcess.TAG_NAME, new MetaSubProcessJSONHandler());
			handlers.put(MetaTimer.TAG_NAME, new MetaTimerJSONHandler());
			handlers.put(MetaTimerTask.TAG_NAME, new MetaTimerTaskJOSNHandler());
			handlers.put(Moment.TAG_NAME, new MomentJSONHandler());
			handlers.put(WorkDay.TAG_NAME, new WorkDayJSONHandler());
			handlers.put(TimerMidFormula.TAG_NAME, new TimerMidFormulaJSONHandler());
			handlers.put(TimerSeDevClass.TAG_NAME, new TimerSeDevClassJSONHandler());
			handlers.put(TimerWorkitemCommit.TAG_NAME, new TimerWorkitemCommitJSONHandler());
			handlers.put(MetaInline.TAG_NAME, new MetaInlineJSONHandler());
			handlers.put(MetaDataMap.TAG_NAME, new MetaDataMapJSONHandler());
			handlers.put(MetaBillDataMapInfoCollection.TAG_NAME, new MetaBillDataMapInfoCollectionJSONHandler());
			handlers.put(MetaBillDataMapInfo.TAG_NAME, new MetaBillDataMapInfoJSONHandler());
			handlers.put(MetaComplexJoin.TAG_NAME, new MetaComplexJoinJSONHandler());
			handlers.put(MetaExclusiveFork.TAG_NAME, new MetaExclusiveForkJSONHandler());
			handlers.put(MetaManualTask.TAG_NAME, new MetaManualTaskJSONHandler());
			handlers.put(MetaServiceTask.TAG_NAME, new MetaServiceTaskJSONHandler());
			handlers.put(MetaBranchEnd.TAG_NAME, new MetaBranchEndJSONHandler());
			handlers.put(MetaStateAction.TAG_NAME, new MetaStateActionJSONHandler());
			handlers.put(MetaMultiUserTask.TAG_NAME, new MetaMultiUserTaskJSONHandler());
			handlers.put(MetaMultiAudit.TAG_NAME, new MetaMultiAuditJSONHandler());
			handlers.put(MetaGateWay.TAG_NAME, new MetaGateWayJSONHandler());
			handlers.put(MetaMessageSend.TAG_NAME, new MetaMessageSendJSONHandler());
			handlers.put(MetaMessageCollection.TAG_NAME, new MetaMessageCollectionJSONHandler());
			handlers.put(MetaMessage.TAG_NAME, new MetaMessageJSONHandler());
			handlers.put(MetaMessageReceive.TAG_NAME, new MetaMessageReceiveJSONHandler());
			handlers.put(MetaExclusiveJoin.TAG_NAME, new MetaExclusiveJoinJSONHandler());
			handlers.put(MetaAnchor.TAG_NAME, new MetaAnchorJSONHandler());
			handlers.put(MetaExpand.TAG_NAME, new MetaExpandJSONHandler());
			handlers.put(MetaPreCondition.TAG_NAME, new MetaPreConditionJSONHandler());
			handlers.put(MetaDefaultSequenceFlow.TAG_NAME, new MetaDefaultSequenceFlowJSONHandler());
		}
	}
	
	public static void register(String tagName, AbstractJSONHandler handler) {
		handlers.put(tagName, handler);
	}
	
	@SuppressWarnings("unchecked")
	public static AbstractJSONHandler<AbstractMetaObject,ISerializeContext> getHandler(String tagName) {
		AbstractJSONHandler<AbstractMetaObject,ISerializeContext> handler = handlers.get(tagName);
		if( handler != null ) {
			return handler;
		}
		
		// 调试
		throw new RuntimeException("类型: " + tagName + " 未定义json处理类");
	}
}
