/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.gop.bpm.participator.delegate;

import com.bokesoft.yes.gop.bpm.participator.delegate.Bridge;
import java.util.ArrayList;

public class Island {
    private Long ID = null;
    private boolean land = false;
    private boolean search = false;
    private ArrayList<Bridge> bridgeList = new ArrayList();
    private ArrayList<Bridge> path = new ArrayList();
    private boolean chosen = false;

    public Island(Long l) {
        this.setID(l);
    }

    public void buildBridge(Long l, int n, Island island, String string) {
        for (Bridge bridge : this.bridgeList) {
            if (bridge.getTgt() != island) continue;
            if (bridge.getType() == 1 && n == 2) {
                bridge.setID(l);
                bridge.setType(n);
            }
            return;
        }
        Bridge bridge = new Bridge();
        bridge.setID(l);
        bridge.setSrc(this);
        bridge.setTgt(island);
        bridge.setType(n);
        bridge.setUserInfo(string);
        this.bridgeList.add(bridge);
    }

    public void load(ArrayList<Bridge> arrayList) {
        this.search = true;
        this.setChosen(true);
        for (Bridge bridge : this.bridgeList) {
            if (!bridge.getTgt().cross(bridge, arrayList) || bridge.getType() != 2) continue;
            this.setChosen(false);
        }
    }

    public boolean cross(Bridge object, ArrayList<Bridge> arrayList) {
        if (this.land) {
            return false;
        }
        if (this.search) {
            return false;
        }
        this.search = true;
        arrayList.add((Bridge)object);
        this.path.addAll(arrayList);
        this.setChosen(true);
        for (Bridge bridge : this.bridgeList) {
            if (!bridge.getTgt().cross(bridge, arrayList) || bridge.getType() != 2) continue;
            this.setChosen(false);
        }
        return true;
    }

    public boolean isLand() {
        return this.land;
    }

    public void setLand(boolean bl) {
        this.land = bl;
    }

    public boolean isChosen() {
        return this.chosen;
    }

    public void setChosen(boolean bl) {
        this.chosen = bl;
    }

    public Long getID() {
        return this.ID;
    }

    public void setID(Long l) {
        this.ID = l;
    }

    public ArrayList<Bridge> getPath() {
        return this.path;
    }

    public void clear() {
        this.chosen = false;
        this.land = false;
        this.search = false;
    }
}

