/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.gop.bpm.handler;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.gop.bpm.IExecutionContext;
import com.bokesoft.yes.gop.bpm.IExecutionNode;
import com.bokesoft.yes.gop.bpm.flow.IExecutionFlow;
import com.bokesoft.yes.gop.bpm.handler.IExecutionHandler;
import com.bokesoft.yigo.common.i18n.ILocale;
import java.util.ArrayList;

public interface IBaseHandler
extends IExecutionHandler {
    @Override
    default public void start(IExecutionContext iExecutionContext) throws Throwable {
    }

    @Override
    default public void visit(IExecutionContext iExecutionContext) throws Throwable {
        if (!this.checkPreCondition(iExecutionContext)) {
            this.cleanContext(iExecutionContext);
            this.leave(iExecutionContext);
            return;
        }
        this.preVist(iExecutionContext);
        if (this.repeatInput(iExecutionContext)) {
            this.removeToken(iExecutionContext);
        }
        this.nodeBPMStateChange(iExecutionContext);
        this.leave(iExecutionContext);
    }

    public void removeToken(IExecutionContext var1) throws Throwable;

    public boolean repeatInput(IExecutionContext var1) throws Throwable;

    public void nodeBPMStateChange(IExecutionContext var1) throws Throwable;

    @Override
    default public void leave(IExecutionContext iExecutionContext) throws Throwable {
        boolean bl;
        this.preLeave(iExecutionContext);
        IExecutionNode iExecutionNode = this.getExecutionNode();
        this.createTransitionFlowsWithoutNode();
        Object object = iExecutionNode == null ? null : iExecutionNode.getInterpreterNode();
        if (object != null && object.changeTransitions()) {
            object = object.getEnableTransitionFlows(iExecutionContext);
            this.createTransitionFlowsNode((ArrayList<IExecutionFlow>)object, iExecutionContext);
            if (((ArrayList)object).size() == 0) {
                throw BPMError.getBPMError((ILocale)iExecutionContext.getExecutionEnv(), (int)20, (Object[])new Object[]{iExecutionNode.getCaption()});
            }
        } else {
            object = this.getTransitionFlows();
            this.createTransitionFlowsNode((ArrayList<IExecutionFlow>)object, iExecutionContext);
        }
        if (bl = ((ArrayList)object).size() > 1) {
            this.removeToken(iExecutionContext);
        }
        this.initForkTransitCount(((ArrayList)object).size());
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            IExecutionFlow iExecutionFlow = (IExecutionFlow)object.next();
            this.minusForkTransitCount();
            if (bl) {
                this.createAndInstallToken(iExecutionContext);
            }
            this.handleTransitData(iExecutionContext, iExecutionFlow);
            iExecutionContext.setActiveExecutionNode(iExecutionNode);
            iExecutionFlow.transit(iExecutionContext);
        }
    }

    public void minusForkTransitCount();

    public void initForkTransitCount(int var1);

    public void handleTransitData(IExecutionContext var1, IExecutionFlow var2);

    public void createAndInstallToken(IExecutionContext var1);

    public void installToken(IExecutionContext var1) throws Throwable;

    public void uninstallToken(IExecutionContext var1) throws Throwable;

    public ArrayList<IExecutionFlow> getTransitionFlows();

    public void createTransitionFlowsWithoutNode();

    public void createTransitionFlowsNode(ArrayList<IExecutionFlow> var1, IExecutionContext var2) throws Throwable;

    public boolean checkPreCondition(IExecutionContext var1) throws Throwable;

    public void preVist(IExecutionContext var1) throws Throwable;

    public void preLeave(IExecutionContext var1) throws Throwable;

    public void cleanContext(IExecutionContext var1) throws Throwable;
}

