/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template;

import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yigo.common.def.EExcelTemplateType;
import java.util.Collection;
import java.util.LinkedHashMap;

public class ExcelTemplate {
    public static final int EXCEL_TEMPLATE_VERION = 1;
    private int version = 0;
    private String formKey = null;
    private String dataObjectKey = null;
    private String paras = null;
    private String templateKey = "";
    private EExcelTemplateType type = EExcelTemplateType.Single;
    private ExcelTemplateField detailLinkedField = null;
    private boolean needResetCellIndex = false;
    private LinkedHashMap<String, ExcelTemplateSheet> mapSheets = new LinkedHashMap();

    public ExcelTemplate(String templateKey) {
        this.templateKey = templateKey;
    }

    public String getKey() {
        return this.templateKey;
    }

    public boolean isExcelFormatTemplate() {
        return this.templateKey.endsWith(".xls") || this.templateKey.endsWith(".xlsx");
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public String getDataObjectKey() {
        return this.dataObjectKey;
    }

    public void setDataObjectKey(String dataObjectKey) {
        this.dataObjectKey = dataObjectKey;
    }

    public EExcelTemplateType getType() {
        return this.type;
    }

    public void setType(EExcelTemplateType type) {
        this.type = type;
    }

    public String getParas() {
        return this.paras;
    }

    public void setParas(String paras) {
        this.paras = paras;
    }

    public void setDetailLinkedField(ExcelTemplateField detailLinkedField) {
        this.detailLinkedField = detailLinkedField;
    }

    public ExcelTemplateField getDetailLinkedField() {
        return this.detailLinkedField;
    }

    public boolean isNeedResetCellIndex() {
        return this.needResetCellIndex;
    }

    public void setNeedResetCellIndex(boolean needResetCellIndex) {
        this.needResetCellIndex = needResetCellIndex;
    }

    public ExcelTemplateSheet ensureTemplateSheet(String sheetName) {
        if (!this.mapSheets.containsKey(sheetName)) {
            this.mapSheets.put(sheetName, new ExcelTemplateSheet(sheetName));
        }
        return this.mapSheets.get(sheetName);
    }

    public Collection<ExcelTemplateSheet> getTemplateSheets() {
        return this.mapSheets.values();
    }

    public int getSheetCount() {
        return this.mapSheets.size();
    }

    public Collection<ExcelTemplateTable> getTemplateTables4StampImport() {
        LinkedHashMap<String, ExcelTemplateTable> newTemplateTables = new LinkedHashMap<String, ExcelTemplateTable>();
        for (ExcelTemplateSheet templateSheet : this.getTemplateSheets()) {
            for (ExcelTemplateTable templateTable : templateSheet.getTemplateTables()) {
                String tableKey = templateTable.getTableKey();
                if (newTemplateTables.containsKey(tableKey)) continue;
                newTemplateTables.put(tableKey, templateTable);
            }
        }
        return newTemplateTables.values();
    }

    public Collection<ExcelTemplateTable> getTemplateTables4StampExport() {
        LinkedHashMap<String, ExcelTemplateTable> newTemplateTables = new LinkedHashMap<String, ExcelTemplateTable>();
        for (ExcelTemplateSheet templateSheet : this.getTemplateSheets()) {
            for (ExcelTemplateTable templateTable : templateSheet.getTemplateTables()) {
                String tableKey = templateTable.getTableKey();
                if (!newTemplateTables.containsKey(tableKey)) {
                    newTemplateTables.put(tableKey, new ExcelTemplateTable(tableKey));
                }
                ExcelTemplateTable newTemplateTable = (ExcelTemplateTable)newTemplateTables.get(tableKey);
                newTemplateTable.setDtlTable(templateTable.isDtlTable());
                newTemplateTable.setStartDtlRowIndex(templateTable.getStartDtlRowIndex());
                newTemplateTable.fillDetailHeadFields(templateTable.getDetailHeadFields());
                for (ExcelTemplateField templateField : templateTable.getFields()) {
                    if (templateField.getSourceType() == 2) continue;
                    newTemplateTable.addField(templateField);
                }
            }
        }
        ExcelTemplateTable noSourceTemplateTable = (ExcelTemplateTable)newTemplateTables.get("");
        if (noSourceTemplateTable != null) {
            newTemplateTables.remove("");
            newTemplateTables.put("", noSourceTemplateTable);
        }
        return newTemplateTables.values();
    }

    public boolean hasExpandField() {
        for (ExcelTemplateSheet templateSheet : this.getTemplateSheets()) {
            for (ExcelTemplateTable templateTable : templateSheet.getTemplateTables()) {
                if (!templateTable.hasExpandField()) continue;
                return true;
            }
        }
        return false;
    }
}

