/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template.builder;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.excel.template.builder.AbstractBatchTemplateBuilder;
import com.bokesoft.yes.excel.template.util.ExcelTemplateUtils;
import com.bokesoft.yigo.common.def.EExcelTemplateType;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelCell;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRow;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelSheet;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;

public class MetaMultiBatchTemplateBuilder
extends AbstractBatchTemplateBuilder {
    public MetaMultiBatchTemplateBuilder(MetaExcelWorkbook metaWorkbook, MetaDataObject dataObject) {
        super(metaWorkbook, dataObject);
    }

    @Override
    public ExcelTemplate create() throws Throwable {
        String tableKey = null;
        ExcelTemplateTable templateTable = null;
        ExcelTemplate excelTemplate = ExcelTemplateUtils.createTemplate(this.metaWorkbook.getKey(), this.metaWorkbook.getFormKey(), this.dataObject.getKey(), this.metaWorkbook.isNeedResetCellIndex(), EExcelTemplateType.MultiBatch);
        this.initDetailLinkField(excelTemplate);
        for (MetaExcelSheet sheet : this.metaWorkbook.getList()) {
            for (MetaExcelRow row : sheet.getRows()) {
                tableKey = row.getTableKey();
                for (MetaExcelCell cell : row.getList()) {
                    if (cell.getSourceType() != 0 || cell.isDetailLinked().booleanValue() || StringUtil.isBlankOrNull((String)(tableKey = StringUtil.isBlankOrNull((String)tableKey) ? cell.getTableKey() : tableKey))) continue;
                    ExcelTemplateSheet sheetTemplate = excelTemplate.ensureTemplateSheet(tableKey);
                    this.ensureTemplateTable4Batch(sheetTemplate, "");
                    templateTable = this.ensureTemplateTable4Batch(sheetTemplate, tableKey);
                    int colIndex = templateTable.getFieldCount() / 2 + 1;
                    ExcelTemplateField templateField = ExcelTemplateField.create(cell.getDefinition(), 2, colIndex, tableKey);
                    ExcelTemplateUtils.initTemplateFieldByMeta(templateField, cell, true);
                    templateTable.addField(templateField);
                    MetaTable metaTable = this.dataObject.getTable(tableKey);
                    MetaColumn column = (MetaColumn)metaTable.get(cell.getDefinition());
                    ExcelTemplateField titleField = ExcelTemplateField.create(column.getCaption(), 1, colIndex, tableKey);
                    templateTable.addField(titleField);
                }
            }
        }
        this.resetBatchFields(excelTemplate, false);
        return excelTemplate;
    }

    private void initDetailLinkField(ExcelTemplate excelTemplate) {
        MetaExcelCell detailLinkedCell = this.metaWorkbook.getDetailLinkedCell();
        if (detailLinkedCell == null || StringUtil.isBlankOrNull((String)detailLinkedCell.getTableKey())) {
            return;
        }
        for (MetaExcelSheet metaSheet : this.metaWorkbook.getList()) {
            String fieldKey = detailLinkedCell.getDefinition();
            MetaTable metaTable = this.dataObject.getTable(detailLinkedCell.getTableKey());
            MetaColumn column = (MetaColumn)metaTable.get(fieldKey);
            for (String tableKey : metaSheet.getTableKeyList()) {
                ExcelTemplateSheet sheetTemplate = excelTemplate.ensureTemplateSheet(tableKey);
                sheetTemplate.ensureTemplateTable("");
                ExcelTemplateTable templateTable = this.ensureTemplateTable4Batch(sheetTemplate, tableKey);
                if (templateTable.existDetailLinkedField()) continue;
                ExcelTemplateField detailLinkedField = ExcelTemplateField.create(fieldKey, 2, 1, sheetTemplate.getSheetName());
                ExcelTemplateUtils.initTemplateFieldByMeta(detailLinkedField, detailLinkedCell, true);
                detailLinkedField.setDetailLinkField(true);
                detailLinkedField.setIgnore4Import(true);
                templateTable.addField(detailLinkedField);
                if (excelTemplate.getDetailLinkedField() == null) {
                    excelTemplate.setDetailLinkedField(detailLinkedField);
                }
                ExcelTemplateField detailLinkedTitleField = ExcelTemplateField.create(column.getCaption(), 1, 1, sheetTemplate.getSheetName());
                templateTable.addField(detailLinkedTitleField);
            }
        }
    }
}

