/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.datamap.calculate;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.struct.datatype.DataTypeAction;
import com.bokesoft.yes.struct.datatype.DataTypeActionFactory;
import com.bokesoft.yigo.common.json.JSONSerializable;
import java.math.BigDecimal;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class MapValueResult
implements JSONSerializable {
    public static final String SIZE = "size";
    public static final String OID_ARRAY = "OID_array";
    public static final String VALUE_ARRAY = "value_array";
    private TreeMap<Long, BigDecimal> valueMap = null;

    public MapValueResult() {
        this.valueMap = new TreeMap();
    }

    public MapValueResult(TreeMap<Long, BigDecimal> treeMap) {
        this.valueMap = treeMap;
    }

    public BigDecimal getValue(Long l) {
        return this.valueMap.getOrDefault(l, BigDecimal.ZERO);
    }

    public JSONObject toJSON() throws SerializationException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(SIZE, this.valueMap.size());
        JSONArray jSONArray = new JSONArray();
        JSONArray jSONArray2 = new JSONArray();
        DataTypeAction dataTypeAction = DataTypeActionFactory.getDataType((int)4);
        for (Long l : this.valueMap.keySet()) {
            jSONArray.put((Object)l);
            jSONArray2.put(dataTypeAction.toJSON((Object)this.valueMap.get(l)));
        }
        jSONObject.put(OID_ARRAY, (Object)jSONArray);
        jSONObject.put(VALUE_ARRAY, (Object)jSONArray2);
        return jSONObject;
    }

    public void fromJSON(JSONObject jSONObject) throws SerializationException {
        JSONArray jSONArray = jSONObject.getJSONArray(OID_ARRAY);
        JSONArray jSONArray2 = jSONObject.getJSONArray(VALUE_ARRAY);
        int n = jSONObject.getInt(SIZE);
        DataTypeAction dataTypeAction = DataTypeActionFactory.getDataType((int)4);
        for (int i = 0; i < n; ++i) {
            Long l = jSONArray.getLong(i);
            this.valueMap.put(l, (BigDecimal)dataTypeAction.fromJSON(jSONArray2.get(i)));
        }
    }
}

