package com.bokesoft.yigo.tools.ve;

import com.bokesoft.yes.tools.env.IGlobalEnv;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.struct.env.Env;

/**
 * VE为执行的虚拟环境，表示一个请求所处的外部环境
 * @author 王元和
 *
 */
public abstract class VE {
	
	protected Env env = null;
	protected IGlobalEnv globalEnv = null;
	
	public VE(IGlobalEnv globalEnv, String host, String port) {
		this.globalEnv = globalEnv;
		env = new Env(host, port);
	}
	
	public IMetaFactory getMetaFactory() {
		if (globalEnv != null) {
			return globalEnv.getMetaFactory();
		}
		return null;
	}
	
	public void setClientID(String clientID) {
		this.env.setClientID(clientID);
	}
	
	public String getClientID() {
		return env.getClientID();
	}
	
	public void setTempClientID(String tmpClientID) {
		env.setTempClientID(tmpClientID);
	}
	
	public String getTempClientID() {
		return env.getTempClientID();
	}
	
	public Env getEnv() {
		return env;
	}
	
	public ClassLoader getPluginClassLoader() {
		if (globalEnv != null) {
			return globalEnv.getPluginsClassLoader();
		}
		return null;
	}

	public IGlobalEnv getGlobalEnv() {
		return globalEnv;
	}

	public void setGlobalEnv(IGlobalEnv globalEnv) {
		this.globalEnv = globalEnv;
	}

	public abstract void destory() throws Throwable ;

	public abstract VE clone();
	
}
