package com.bokesoft.yigo.tools.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.bokesoft.yes.common.util.DBDataConvertor;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yigo.common.def.*;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.document.Document;

public class DocumentUtil {
	private static final List<String> systemFields = new ArrayList<String>();

	static {
		systemFields.add(SystemField.OID_SYS_KEY);
		systemFields.add(SystemField.POID_SYS_KEY);
		systemFields.add(SystemField.SOID_SYS_KEY);
		systemFields.add(SystemField.DVERID_SYS_KEY);
		systemFields.add(SystemField.VERID_SYS_KEY);
		systemFields.add(SystemField.INSTANCE_ID_SYS_KEY);
	}

	/**
	 * 根据表单的标识创建一个文档数据Document,创建的文档默认状态是Normal,
	 * 新增状态时,需要自己调用setNew方法
	 *
	 * @param formKey
	 *            表单标识
	 * @return 表单数据源对应的文档
	 * @throws Throwable
	 */
	@Deprecated
	public static Document newDocument(String formKey) throws Throwable {
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		MetaDataSource dataSource = metaForm.getDataSource();
		if (dataSource == null)
			return null;
		return newDocument(dataSource.getDataObject());
	}

	/**
	 * 根据表单的标识创建一个文档数据Document,创建的文档默认状态是Normal,
	 * 新增状态时,需要自己调用setNew方法
	 *
	 * @param formKey
	 *            表单标识
	 * @param metaFactory 配置工厂          
	 * @return 表单数据源对应的文档
	 * @throws Throwable
	 */
	public static Document newDocument(String formKey, IMetaFactory metaFactory) throws Throwable {
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		MetaDataSource dataSource = metaForm.getDataSource();
		if (dataSource == null)
			return null;
		return newDocument(dataSource.getDataObject());
	}

	/**
	 * 根据数据对象创建文档数据对象,创建的文档默认状态是Normal,
	 * 新增状态时,需要自己调用setNew方法
	 *
	 * @param dataObject
	 *            数据对象
	 * @return 数据对象对应的文档
	 * @throws Throwable 处理异常
	 */
	public static Document newDocument(MetaDataObject dataObject) throws Throwable {
		Document document = new Document(dataObject, -1);

		MetaTableCollection metaTableCollection = dataObject.getTableCollection();
		Iterator<MetaTable> it = metaTableCollection.iterator();
		MetaTable metaTable = null;
		while (it.hasNext()) {
			metaTable = it.next();
			DataTable table = DataTableUtil.newEmptyDataTable(metaTable);
			if (metaTable.getTableMode() == TableMode.HEAD) {
				newRow(metaTable, table);
			}
			document.add(metaTable.getKey(), table);
		}
		return document;
	}

	/**
	 * 新增基于数据对象特定表的文档对象
	 *
	 * @param dataObject
	 *            数据对象
	 * @param tableKey
	 *            表标识
	 * @return 文档对象
	 * @throws Throwable 处理异常
	 */
	public static Document newDetailDocument(MetaDataObject dataObject, String tableKey) throws Throwable {
		Document document = new Document(dataObject, -1);

		MetaTableCollection metaTableCollection = dataObject.getTableCollection();
		MetaTable metaTable = metaTableCollection.get(tableKey);
		DataTable table = DataTableUtil.newEmptyDataTable(metaTable);
		newRow(metaTable, table);
		document.add(tableKey, table);
		return document;
	}

	/**
	 * 生成数据表对象为影子表的document对象
	 *
	 * @param tableKey
	 *            数据表对象
	 * @param document
	 *            文档对象
	 * @return 新文档对象
	 */
	public static Document resolveData(Document document) {
		MetaDataObject metaDataObject = document.getMetaDataObject();
		Long OID = document.getOID();
		Document newDoc = new Document(metaDataObject, OID);
		MetaTableCollection collection = metaDataObject.getTableCollection();
		for (MetaTable metaTable : collection) {
			String key = metaTable.getKey();
			DataTable table = document.get(key);
			DataTable shadowTable = document.getShadowTable(key);
			if ( shadowTable != null ) {
				newDoc.add(key, shadowTable);
			} else {
				newDoc.add(key, table);
			}
		}
		return newDoc;
	}

	/**
	 * 数据表新增一行,并赋予默认值
	 *
	 * @param metaTable
	 *            配置表
	 * @param table
	 *            数据表
	 * @return 新行的位置
	 * @throws Throwable 处理异常
	 */
	public static int newRow(MetaTable metaTable, DataTable table) throws Throwable {
		int newIndex = table.append();
		Iterator<MetaColumn> itColumn = metaTable.iterator();

		String defaultValue = null;
		Object value = null;
		String key = null;
		while (itColumn.hasNext()) {
			MetaColumn metaColumn = itColumn.next();

			if (metaColumn.isSupportI18n())
				continue;

			defaultValue = metaColumn.getDefaultValue();
			key = metaColumn.getKey();
			if(defaultValue != null){
				if (defaultValue.isEmpty()){
					if(metaColumn.getDataType() == DataType.STRING ||
							metaColumn.getDataType() == DataType.TEXT ||
							metaColumn.getDataType() == DataType.FIXED_STRING){
						
						table.setObject(key, "");
					}else {
						// 字段数值类型的默认值设为 0
						if (metaColumn.isNumeric()) {
							value = TypeConvertor.toDataType(metaColumn.getDataType(), 0);
							table.setObject(key, value);
						}
					}
				}else{
					value = DBDataConvertor.toConstValue(metaColumn.getDataType(), defaultValue);
					table.setObject(key, value);
				}
			}else {
				// 字段数值类型的默认值设为 0
				if (metaColumn.isNumeric()) {
					value = TypeConvertor.toDataType(metaColumn.getDataType(), 0);
					table.setObject(key, value);
				} else if (metaColumn.isString()) {
					table.setObject(key, "");
				}
			}
		}
		return newIndex;
	}

	/**
	 * 为后台构造的Document分配排序字段的值
	 * 这个API只能给未分配Sequence字段的数据表使用,
	 * 进行简单的赋值操作
	 *
	 * @param document
	 *            文档对象
	 */
	public static void calcSequence(Document document) {
		Iterator<MetaTable> itMetaTable = document.getMetaDataObject().getTableCollection().iterator();
		while (itMetaTable.hasNext()) {
			MetaTable metaTable = itMetaTable.next();
			if (metaTable.getTableMode() == TableMode.DETAIL && metaTable.containsKey(SystemField.SEQUENCE_SYS_KEY)) {
				DataTable dataTable = document.get(metaTable.getKey());
				int curSeq = 0;
				int seqIndex = dataTable.getMetaData().findColumnIndexByKey(SystemField.SEQUENCE_SYS_KEY);
				for (int i = 0; i < dataTable.size(); i++) {
					dataTable.setPos(i);
					Integer sequence = (Integer) dataTable.getObject(seqIndex);
					if (sequence == null || sequence <= curSeq) {
						sequence = curSeq + 1;
						dataTable.setInt(seqIndex, sequence);
					}
					curSeq = sequence;
				}
			}
		}
	}

	private static Object initValue(MetaColumn metaColumn) throws Throwable {
		Object value = null;
		String defaultValue = metaColumn.getDefaultValue();
		if (!StringUtil.isBlankOrNull(defaultValue)) {
			value = DBDataConvertor.toConstValue(metaColumn.getDataType(), defaultValue);
		} else if ( metaColumn.isNumeric() ) {
			value = TypeConvertor.toDataType(metaColumn.getDataType(), 0);
		} else if ( metaColumn.isString() ) {
			value = "";
		}
		return value;
	}

	public static List<String> copyNew(Document document,MetaForm metaForm) throws Throwable {
		MetaDataObject metaDataObject = metaForm.getDataSource().getDataObject();
		MetaTableCollection metaTableCollection = metaDataObject.getTableCollection();
		Iterator<Entry<String, MetaTable>> it = metaTableCollection.entryIterator();
		List<String> ignoreKeys = new ArrayList<String>();
		Entry<String, MetaTable> entry = null;

		// 子明细父子关系处理
		while ( it.hasNext() ) {
			entry = it.next();
			MetaTable metaTable = entry.getValue();
			DataTable table = document.get(metaTable.getKey());

			String parentKey = metaTable.getParentKey();
			if (!StringUtil.isBlankOrNull(parentKey)) {
				MetaComponent meta = metaForm.findComponentByTable(parentKey);
				if( meta != null && !meta.isCopyNew() ) {
					table.clear();
					table.setNew();
					continue;
				} else {
					DataTable parentTable = document.get(parentKey);
					Map<Long, Integer> bkmkMap = new HashMap<Long, Integer>();
					parentTable.beforeFirst();
					while( parentTable.next() ) {
						bkmkMap.put(parentTable.getLong(SystemField.OID_SYS_KEY), parentTable.getBookmark());
					}
					table.afterLast();
					while( table.previous() ) {
						if( table.getParentBookmark() == -1 ) {
							Integer parentBkmk = bkmkMap.get(table.getLong(SystemField.POID_SYS_KEY));
							if( parentBkmk != null && parentBkmk >= 0 ) {
								table.setParentBookmark(parentBkmk);
							} else {
								table.setState(RowState.NEW);
								table.delete();
							}
						}
					}
				}
			}
		}

		// 数据处理
		it = metaTableCollection.entryIterator();
		while ( it.hasNext() ) {
			entry = it.next();
			MetaTable metaTable = entry.getValue();
			DataTable table = document.get(metaTable.getKey());

			DataTableMetaData metaData = table.getMetaData();
			if( metaTable.getTableMode() == TableMode.HEAD ) {
				table.first();
				for( int i = 0,size = metaData.getColumnCount();i < size;i++ ) {
					ColumnInfo info = metaData.getColumnInfo(i);
					String columnKey = info.getColumnKey();
					MetaComponent meta = metaForm.getComponentByDataBinding(table.getKey(), columnKey);
					if( meta != null ) {
						if( meta.isCopyNew() ) {
							ignoreKeys.add(meta.getKey());
						} else {
							table.setObject(columnKey, initValue(metaTable.get(columnKey)));
						}
					}
					if( SystemField.isSystemField(columnKey) ) {
						table.setObject(columnKey, initValue(metaTable.get(columnKey)));
					}
				}
			} else {
				MetaComponent meta = metaForm.findComponentByTable(metaTable.getKey());
				if( meta != null && meta.getControlType() == ControlType.GRID ) {
					if( meta.isCopyNew() ) {
						for( int i = 0,size = metaData.getColumnCount();i < size;i++ ) {
							ColumnInfo info = metaData.getColumnInfo(i);
							String columnKey = info.getColumnKey();
							MetaGridCell metaCell = metaForm.getCellByDataBinding(table.getKey(), columnKey);
							if( metaCell != null ) {
								if( !meta.isCopyNew() || !metaCell.isCopyNew() ) {
									table.beforeFirst();
									while ( table.next() ) {
										table.setObject(columnKey, initValue(metaTable.get(columnKey)));
									}
								} else {
									ignoreKeys.add(metaCell.getKey());
								}
							}
							if( SystemField.isSystemField(columnKey) ) {
								table.beforeFirst();
								while ( table.next() ) {
									table.setObject(columnKey, initValue(metaTable.get(columnKey)));
								}
							}
						}
					} else {
						table.clear();
					}
				}
			}
			table.setNew();
		}

		document.setNew();

		document.clearAllShadow();

		return ignoreKeys;
	}

}